/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.taskexecutor.slot.SlotOffer;

public class TaskExecutionStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ExecutionState executionState;
    private final int attemptNumber;
    private final long createTimestamp;
    private final JobVertexID jobVertexID;
    private final ExecutionAttemptID executionAttemptID;
    private final int indexOfSubtask;
    private final ResultPartitionID[] resultPartitionIDs;
    private final boolean[] resultPartitionsConsumable;
    private final Map<OperatorID, List<InputSplit>> assignedInputSplits;
    private final SlotOffer boundSlot;

    public TaskExecutionStatus(ExecutionState executionState, int attemptNumber, long createTimestamp, JobVertexID jobVertexID, ExecutionAttemptID executionAttemptID, int indexOfSubtask, ResultPartitionID[] resultPartitionIDs, boolean[] resultPartitionsConsumable, Map<OperatorID, List<InputSplit>> assignedInputSplits, SlotOffer boundSlot) {
        this.executionState = executionState;
        this.attemptNumber = attemptNumber;
        this.createTimestamp = createTimestamp;
        this.jobVertexID = jobVertexID;
        this.executionAttemptID = executionAttemptID;
        this.indexOfSubtask = indexOfSubtask;
        this.resultPartitionIDs = resultPartitionIDs;
        this.resultPartitionsConsumable = resultPartitionsConsumable;
        this.assignedInputSplits = assignedInputSplits;
        this.boundSlot = boundSlot;
    }

    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    public int getAttemptNumber() {
        return this.attemptNumber;
    }

    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    public JobVertexID getJobVertexID() {
        return this.jobVertexID;
    }

    public ExecutionAttemptID getExecutionAttemptID() {
        return this.executionAttemptID;
    }

    public int getIndexOfSubtask() {
        return this.indexOfSubtask;
    }

    public SlotOffer getBoundSlot() {
        return this.boundSlot;
    }

    public ResultPartitionID[] getResultPartitionIDs() {
        return this.resultPartitionIDs;
    }

    public boolean[] getResultPartitionsConsumable() {
        return this.resultPartitionsConsumable;
    }

    public Map<OperatorID, List<InputSplit>> getAssignedInputSplits() {
        return this.assignedInputSplits;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskExecutionStatus taskExecutionStatus = (TaskExecutionStatus)o;
        return this.executionAttemptID.equals((Object)taskExecutionStatus.getExecutionAttemptID());
    }
}

