/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.Serializable;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.util.FileOffsetRange;

public class FileReadDetail
implements Serializable {
    private static final long serialVersionUID = -7265172816138616979L;
    private final ResourceID taskManagerResourceId;
    private final String fileName;
    private final FileOffsetRange fileOffsetRange;

    public FileReadDetail(ResourceID taskManagerResourceId, String fileName, Long start2, Long size) {
        this.taskManagerResourceId = taskManagerResourceId;
        this.fileName = fileName;
        this.fileOffsetRange = start2 == null || size == null ? null : new FileOffsetRange(start2, size);
    }

    public ResourceID getTaskManagerResourceId() {
        return this.taskManagerResourceId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public FileOffsetRange getFileOffsetRange() {
        return this.fileOffsetRange;
    }

    public int hashCode() {
        return Objects.hash(this.taskManagerResourceId, this.fileName, this.fileOffsetRange);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == FileReadDetail.class) {
            FileReadDetail that = (FileReadDetail)obj;
            return Objects.equals(this.taskManagerResourceId, that.getTaskManagerResourceId()) && Objects.equals(this.fileName, that.getFileName()) && Objects.equals(this.fileOffsetRange, that.getFileOffsetRange());
        }
        return false;
    }

    public String toString() {
        String fileOffsetRangeStr = this.fileOffsetRange == null ? "" : this.fileOffsetRange.toString();
        String fileName = this.fileName == null ? "" : this.fileName;
        StringJoiner joiner = new StringJoiner(",");
        joiner.add("taskManagerResourceId=" + this.taskManagerResourceId.toString());
        joiner.add("fileName=" + fileName);
        joiner.add("fileOffsetRange=(" + fileOffsetRangeStr + ")");
        return joiner.toString();
    }
}

