/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.flink.annotation.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdOutErrRedirector {
    public static final String STDOUT_FILE_PROPERTY_KEY = "stdout.file";
    public static final String STDERR_FILE_PROPERTY_KEY = "stderr.file";
    private static final String STDOUT_LOGGER_NAME = "StdOutErrRedirector.Stdout";
    private static final String STDERR_LOGGER_NAME = "StdOutErrRedirector.Stderr";
    private static final Logger stdoutLogger = LoggerFactory.getLogger((String)"StdOutErrRedirector.Stdout");
    private static final Logger stderrLogger = LoggerFactory.getLogger((String)"StdOutErrRedirector.Stderr");
    private static final ThreadLocal<Boolean> isRedirecting = ThreadLocal.withInitial(() -> false);

    public static void redirectStdOutErr() {
        if (System.getProperty(STDOUT_FILE_PROPERTY_KEY) != null) {
            System.setOut(StdOutErrRedirector.createLoggerProxy(stdoutLogger, System.out));
        }
        if (System.getProperty(STDERR_FILE_PROPERTY_KEY) != null) {
            System.setErr(StdOutErrRedirector.createLoggerProxy(stderrLogger, System.err));
        }
    }

    @VisibleForTesting
    static PrintStream createLoggerProxy(final Logger logger, final PrintStream originalPrintStream) {
        return new PrintStream((OutputStream)originalPrintStream){

            @Override
            public void print(boolean b) {
                this.print(b ? "true" : "false");
            }

            @Override
            public void print(char c) {
                this.print(String.valueOf(c));
            }

            @Override
            public void print(int i) {
                this.print(String.valueOf(i));
            }

            @Override
            public void print(long l) {
                this.print(String.valueOf(l));
            }

            @Override
            public void print(float f) {
                this.print(String.valueOf(f));
            }

            @Override
            public void print(double d) {
                this.print(String.valueOf(d));
            }

            @Override
            public void print(char[] s) {
                this.print(new String(s));
            }

            @Override
            public void print(String s) {
                if (!((Boolean)isRedirecting.get()).booleanValue()) {
                    try {
                        isRedirecting.set(true);
                        logger.info(s);
                    }
                    finally {
                        isRedirecting.set(false);
                    }
                } else {
                    originalPrintStream.print(s);
                }
            }

            @Override
            public void print(Object obj) {
                this.print(String.valueOf(obj));
            }

            void newLine() {
                this.print(System.lineSeparator());
            }

            @Override
            public void println() {
                this.newLine();
            }

            @Override
            public void println(boolean b) {
                this.print(b);
                this.newLine();
            }

            @Override
            public void println(char c) {
                this.print(c);
                this.newLine();
            }

            @Override
            public void println(int i) {
                this.print(i);
                this.newLine();
            }

            @Override
            public void println(long l) {
                this.print(l);
                this.newLine();
            }

            @Override
            public void println(float f) {
                this.print(f);
                this.newLine();
            }

            @Override
            public void println(double d) {
                this.print(d);
                this.newLine();
            }

            @Override
            public void println(char[] s) {
                this.print(s);
                this.newLine();
            }

            @Override
            public void println(String s) {
                this.print(s);
                this.newLine();
            }

            @Override
            public void println(Object obj) {
                this.print(obj);
                this.newLine();
            }

            @Override
            public PrintStream append(CharSequence csq, int start2, int end) {
                CharSequence cs = csq == null ? "null" : csq;
                this.print(cs.subSequence(start2, end).toString());
                return this;
            }
        };
    }

    @VisibleForTesting
    static boolean isRedirecting() {
        return isRedirecting.get();
    }
}

