/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor.retriever.impl;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.rpc.FencedRpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.webmonitor.retriever.LeaderGatewayRetriever;
import org.apache.flink.util.Preconditions;

public class RpcGatewayRetriever<F extends Serializable, T extends FencedRpcGateway<F>>
extends LeaderGatewayRetriever<T> {
    private final RpcService rpcService;
    private final Class<T> gatewayType;
    private final Function<UUID, F> fencingTokenMapper;
    private final int retries;
    private final Time retryDelay;

    public RpcGatewayRetriever(RpcService rpcService, Class<T> gatewayType, Function<UUID, F> fencingTokenMapper, int retries, Time retryDelay) {
        this.rpcService = (RpcService)Preconditions.checkNotNull((Object)rpcService);
        this.gatewayType = (Class)Preconditions.checkNotNull(gatewayType);
        this.fencingTokenMapper = (Function)Preconditions.checkNotNull(fencingTokenMapper);
        Preconditions.checkArgument((retries >= 0 ? 1 : 0) != 0, (Object)"The number of retries must be greater or equal to 0.");
        this.retries = retries;
        this.retryDelay = (Time)Preconditions.checkNotNull((Object)retryDelay);
    }

    @Override
    protected CompletableFuture<T> createGateway(CompletableFuture<Tuple2<String, UUID>> leaderFuture) {
        return FutureUtils.retryWithDelay(() -> leaderFuture.thenCompose(addressLeaderTuple -> this.rpcService.connect((String)addressLeaderTuple.f0, (Serializable)this.fencingTokenMapper.apply((UUID)addressLeaderTuple.f1), this.gatewayType)), this.retries, this.retryDelay, this.rpcService.getScheduledExecutor());
    }
}

