/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.bundle;

import org.apache.flink.streaming.api.bundle.BundleTriggerCallback;
import org.apache.flink.streaming.api.bundle.CoBundleTrigger;
import org.apache.flink.util.Preconditions;

public class CountCoBundleTrigger<L, R>
implements CoBundleTrigger<L, R> {
    private long maxCount;
    private transient BundleTriggerCallback callback;
    private transient long count = 0L;

    public CountCoBundleTrigger(long maxCount) {
        Preconditions.checkArgument((maxCount > 0L ? 1 : 0) != 0, (Object)"maxCount must be greater than 0");
        this.maxCount = maxCount;
    }

    @Override
    public void registerBundleTriggerCallback(BundleTriggerCallback callback) {
        this.callback = (BundleTriggerCallback)Preconditions.checkNotNull((Object)callback, (String)"callback is null");
    }

    @Override
    public void onLeftElement(L element) throws Exception {
        ++this.count;
        if (this.count >= this.maxCount) {
            this.callback.finishBundle();
        }
    }

    @Override
    public void onRightElement(R element) throws Exception {
        ++this.count;
        if (this.count >= this.maxCount) {
            this.callback.finishBundle();
        }
    }

    @Override
    public void reset() {
        this.count = 0L;
    }

    @Override
    public String explain() {
        return "CountCoBundleTrigger with triggerSize is " + this.maxCount;
    }
}

