/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.operators.ResourceConstraints;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.StreamSink;
import org.apache.flink.streaming.api.transformations.SinkTransformation;
import org.apache.flink.util.Preconditions;

@Public
public class DataStreamSink<T> {
    private final SinkTransformation<T> transformation;

    protected DataStreamSink(DataStream<T> inputStream, StreamSink<T> operator) {
        this.transformation = new SinkTransformation<T>(inputStream.getTransformation(), "Unnamed", operator, inputStream.getExecutionEnvironment().getParallelism());
    }

    @Internal
    public SinkTransformation<T> getTransformation() {
        return this.transformation;
    }

    @Internal
    public int getId() {
        return this.transformation.getId();
    }

    public DataStreamSink<T> name(String name) {
        this.transformation.setName(name);
        return this;
    }

    @PublicEvolving
    public DataStreamSink<T> uid(String uid) {
        this.transformation.setUid(uid);
        return this;
    }

    @PublicEvolving
    public DataStreamSink<T> setUidHash(String uidHash) {
        this.transformation.setUidHash(uidHash);
        return this;
    }

    public DataStreamSink<T> setParallelism(int parallelism) {
        this.transformation.setParallelism(parallelism);
        return this;
    }

    public DataStreamSink<T> setResources(ResourceSpec minResources, ResourceSpec preferredResources) {
        Preconditions.checkNotNull((Object)minResources, (String)"The min resources must be not null.");
        Preconditions.checkNotNull((Object)preferredResources, (String)"The preferred resources must be not null.");
        Preconditions.checkArgument((minResources.isValid() && preferredResources.isValid() && minResources.lessThanOrEqual(preferredResources) ? 1 : 0) != 0, (Object)"The values in resources must be not less than 0 and the preferred resources must be greater than the min resources.");
        this.transformation.setResources(minResources, preferredResources);
        return this;
    }

    public DataStreamSink<T> setResources(ResourceSpec resources) {
        Preconditions.checkNotNull((Object)resources, (String)"The resources must be not null.");
        Preconditions.checkArgument((boolean)resources.isValid(), (Object)"The values in resources must be not less than 0.");
        this.transformation.setResources(resources, resources);
        return this;
    }

    public DataStreamSink<T> setResourceConstraints(ResourceConstraints constraints) {
        this.transformation.setResourceConstraints(constraints);
        return this;
    }

    @PublicEvolving
    public DataStreamSink<T> disableChaining() {
        this.transformation.setChainingStrategy(ChainingStrategy.NEVER);
        return this;
    }

    @PublicEvolving
    public DataStreamSink<T> slotSharingGroup(String slotSharingGroup) {
        this.transformation.setSlotSharingGroup(slotSharingGroup);
        return this;
    }

    @PublicEvolving
    public DataStreamSink<T> setConfigItem(ConfigOption<String> key, String value) {
        this.transformation.getCustomConfiguration().setString(key, value);
        return this;
    }

    public DataStreamSink<T> setConfigItem(String key, String value) {
        this.transformation.getCustomConfiguration().setString(key, value);
        return this;
    }
}

