/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.driver;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.flink.api.common.DriverProgram;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.driver.DriverSourceFunction;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunction;

public class DriverEntry
implements DriverProgram {
    private static PackagedProgram packagedProgram;
    private static String clusterIp;
    private static int clusterPort;
    private static Configuration configuration;
    private static String driveName;

    public void setParameter(Object parameter) {
        if (parameter == null || parameter instanceof PackagedProgram) {
            packagedProgram = (PackagedProgram)parameter;
        }
    }

    public void setClusterInfo(String ip, int port) {
        clusterIp = ip;
        clusterPort = port;
    }

    public void setConfiguration(Configuration configuration) {
        DriverEntry.configuration = configuration;
    }

    public static void main(String[] args) throws Exception {
        driveName = "FlinkDriverJob_" + System.currentTimeMillis();
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        DriverEntry.manageJobBlobs(env, packagedProgram.getAllLibraries());
        DriverEntry.manageJobBlobs(env, packagedProgram.getFiles());
        env.addSource(DriverEntry.createSourceFunction()).addSink(new SinkFunction<Byte>(){

            @Override
            public void invoke(Byte value, SinkFunction.Context context) throws Exception {
            }
        });
        env.submit(driveName);
    }

    private static SourceFunction<Byte> createSourceFunction() {
        DriverSourceFunction driverSourceFunction = new DriverSourceFunction(clusterIp, clusterPort, driveName, packagedProgram.getDriverClass(), packagedProgram.getArguments(), packagedProgram.getAllLibraries(), packagedProgram.getFiles().stream().map(uri -> {
            try {
                return uri.toURL();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                return null;
            }
        }).collect(Collectors.toList()), configuration);
        return driverSourceFunction;
    }

    private static void manageJobBlobs(StreamExecutionEnvironment env, List<? extends Object> jobBlobs) {
        for (Object object : jobBlobs) {
            URL url = null;
            if (object instanceof URI) {
                try {
                    url = ((URI)object).toURL();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            } else if (object instanceof URL) {
                url = (URL)object;
            }
            if (url == null) continue;
            String fileName = FilenameUtils.getName((String)url.getPath());
            env.registerCachedFile(url.toString(), fileName);
        }
    }

    static {
        clusterPort = -1;
    }
}

