/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.InvalidProgramException;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public class LocalStreamEnvironment
extends StreamExecutionEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(LocalStreamEnvironment.class);
    private final Configuration configuration;
    private Map<JobID, MiniCluster> submitMapping = new HashMap<JobID, MiniCluster>();

    public LocalStreamEnvironment() {
        this(new Configuration());
    }

    public LocalStreamEnvironment(@Nonnull Configuration configuration) {
        if (!ExecutionEnvironment.areExplicitEnvironmentsAllowed()) {
            throw new InvalidProgramException("The LocalStreamEnvironment cannot be used when submitting a program through a client, or running in a TestEnvironment context.");
        }
        this.configuration = configuration;
        this.setParallelism(1);
    }

    protected Configuration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JobSubmissionResult executeInternal(String jobName, boolean detached, SavepointRestoreSettings savepointRestoreSettings) throws Exception {
        StreamGraph streamGraph = this.getStreamGraph();
        streamGraph.setJobName(jobName);
        JobGraph jobGraph = streamGraph.getJobGraph();
        jobGraph.setSavepointRestoreSettings(savepointRestoreSettings);
        jobGraph.setAllowQueuedScheduling(true);
        MiniCluster miniCluster = this.prepareMiniCluster(jobGraph);
        try {
            JobSubmissionResult jobSubmissionResult = miniCluster.executeJob(jobGraph, detached);
            return jobSubmissionResult;
        }
        finally {
            this.transformations.clear();
            if (!detached) {
                miniCluster.close();
            } else {
                this.submitMapping.put(jobGraph.getJobID(), miniCluster);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobExecutionResult execute(StreamGraph streamGraph) throws Exception {
        JobGraph jobGraph = streamGraph.getJobGraph();
        jobGraph.setAllowQueuedScheduling(true);
        MiniCluster miniCluster = this.prepareMiniCluster(jobGraph);
        try {
            JobExecutionResult jobExecutionResult = (JobExecutionResult)miniCluster.executeJob(jobGraph, false);
            return jobExecutionResult;
        }
        finally {
            this.transformations.clear();
            miniCluster.close();
        }
    }

    @Override
    public void stopJob(JobID jobID) throws Exception {
        MiniCluster miniCluster = this.submitMapping.get(jobID);
        if (miniCluster == null) {
            throw new RuntimeException("Try to stop an untraceable job");
        }
        miniCluster.stopJob(jobID).get();
        miniCluster.close();
        this.submitMapping.remove(jobID);
    }

    private MiniCluster prepareMiniCluster(JobGraph jobGraph) throws Exception {
        Configuration configuration = new Configuration();
        configuration.addAll(jobGraph.getJobConfiguration());
        configuration.setInteger(TaskManagerOptions.TASK_MANAGER_HEAP_MEMORY, 0x1FFFFFFF);
        configuration.setDouble(TaskManagerOptions.TASK_MANAGER_CORE, 5.36870911E8);
        configuration.setLong(TaskManagerOptions.MANAGED_MEMORY_SIZE, 524287L);
        configuration.addAll(this.configuration);
        if (!configuration.contains(RestOptions.PORT)) {
            configuration.setInteger(RestOptions.PORT, 0);
        }
        int numSlotsPerTaskManager = configuration.getInteger(TaskManagerOptions.NUM_TASK_SLOTS, jobGraph.getMaximumParallelism() * jobGraph.getNumberOfVertices());
        MiniClusterConfiguration cfg = new MiniClusterConfiguration.Builder().setConfiguration(configuration).setNumSlotsPerTaskManager(numSlotsPerTaskManager).build();
        if (LOG.isInfoEnabled()) {
            LOG.info("Running job on local embedded Flink mini cluster");
        }
        MiniCluster miniCluster = new MiniCluster(cfg);
        miniCluster.start();
        configuration.setInteger(RestOptions.PORT, miniCluster.getRestAddress().getPort());
        return miniCluster;
    }

    @Override
    public void cancel(String jobId) {
    }

    @Override
    public String triggerSavepoint(String jobId, String path) throws Exception {
        throw new IOException("not supported");
    }
}

