/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.source;

import org.apache.flink.annotation.Public;
import org.apache.flink.streaming.api.watermark.Watermark;

@Public
public class SourceRecord<T> {
    private T record;
    private long timestamp = -1L;
    private Watermark watermark;

    public SourceRecord<T> reset() {
        this.record = null;
        this.timestamp = -1L;
        this.watermark = null;
        return this;
    }

    public T getRecord() {
        return this.record;
    }

    public void setRecord(T record) {
        this.record = record;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public Watermark getWatermark() {
        return this.watermark;
    }

    public void setWatermark(Watermark watermark) {
        this.watermark = watermark;
    }

    public SourceRecord<T> replace(T record) {
        this.reset();
        this.setRecord(record);
        return this;
    }

    public SourceRecord<T> replace(T record, long timestamp) {
        this.reset();
        this.setRecord(record);
        this.setTimestamp(timestamp);
        return this;
    }

    public SourceRecord<T> replace(Watermark watermark) {
        this.reset();
        this.setWatermark(watermark);
        return this;
    }

    public static <T> SourceRecord<T> create(T record) {
        SourceRecord<T> sourceRecord = new SourceRecord<T>();
        sourceRecord.setRecord(record);
        return sourceRecord;
    }

    public static <T> SourceRecord<T> create(T record, long timestamp) {
        SourceRecord<T> sourceRecord = new SourceRecord<T>();
        sourceRecord.setRecord(record);
        sourceRecord.setTimestamp(timestamp);
        return sourceRecord;
    }

    public static <T> SourceRecord<T> create(Watermark watermark) {
        SourceRecord<T> sourceRecord = new SourceRecord<T>();
        sourceRecord.setWatermark(watermark);
        return sourceRecord;
    }
}

