/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.runtime.io.BarrierBuffer;
import org.apache.flink.streaming.runtime.io.BarrierTracker;
import org.apache.flink.streaming.runtime.io.BufferSpiller;
import org.apache.flink.streaming.runtime.io.CachedBufferBlocker;
import org.apache.flink.streaming.runtime.io.InputGateUtil;
import org.apache.flink.streaming.runtime.io.SelectedReadingBarrierHandler;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.util.Preconditions;

@Internal
public class InputProcessorUtil {
    public static SelectedReadingBarrierHandler createCheckpointBarrierHandler(boolean isCheckpointingEnabled, StreamTask<?, ?> checkpointedTask, CheckpointingMode checkpointMode, IOManager ioManager, Configuration taskManagerConfig, Collection<InputGate> ... inputGateGroups) throws IOException {
        InputGate[][] inputGateGroupArray = new InputGate[inputGateGroups.length][];
        for (int i = 0; i < inputGateGroups.length; ++i) {
            inputGateGroupArray[i] = inputGateGroups[i].toArray(new InputGate[0]);
        }
        return InputProcessorUtil.createCheckpointBarrierHandler(isCheckpointingEnabled, checkpointedTask, checkpointMode, ioManager, taskManagerConfig, inputGateGroupArray);
    }

    public static SelectedReadingBarrierHandler createCheckpointBarrierHandler(boolean isCheckpointingEnabled, StreamTask<?, ?> checkpointedTask, CheckpointingMode checkpointMode, IOManager ioManager, Configuration taskManagerConfig, InputGate[] ... inputGateGroups) throws IOException {
        SelectedReadingBarrierHandler barrierHandler;
        Preconditions.checkState((inputGateGroups.length > 0 ? 1 : 0) != 0);
        InputGate[] unionInputGates = new InputGate[inputGateGroups.length];
        for (int i = 0; i < inputGateGroups.length; ++i) {
            unionInputGates[i] = InputGateUtil.createInputGate(new InputGate[][]{inputGateGroups[i]});
        }
        InputGate rootUnionInputGate = InputGateUtil.createInputGate(new InputGate[][]{unionInputGates});
        if (!isCheckpointingEnabled || checkpointMode == CheckpointingMode.AT_LEAST_ONCE) {
            barrierHandler = new BarrierTracker(rootUnionInputGate);
        } else if (checkpointMode == CheckpointingMode.EXACTLY_ONCE) {
            long maxAlign = taskManagerConfig.getLong(TaskManagerOptions.TASK_CHECKPOINT_ALIGNMENT_BYTES_LIMIT);
            if (maxAlign != -1L && maxAlign <= 0L) {
                throw new IllegalConfigurationException(TaskManagerOptions.TASK_CHECKPOINT_ALIGNMENT_BYTES_LIMIT.key() + " must be positive or -1 (infinite)");
            }
            barrierHandler = taskManagerConfig.getBoolean(TaskManagerOptions.NETWORK_CREDIT_MODEL) ? new BarrierBuffer(rootUnionInputGate, new CachedBufferBlocker(rootUnionInputGate.getPageSize()), maxAlign) : new BarrierBuffer(rootUnionInputGate, new BufferSpiller(ioManager, rootUnionInputGate.getPageSize()), maxAlign);
        } else {
            throw new IllegalArgumentException("Unrecognized Checkpointing Mode: " + (Object)((Object)checkpointMode));
        }
        if (checkpointedTask != null) {
            barrierHandler.registerCheckpointEventHandler(checkpointedTask);
        }
        return barrierHandler;
    }
}

