/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.util.Preconditions;

public interface InputSelector {
    public void registerSelectionChangedListener(SelectionChangedListener var1);

    public List<InputSelection> getNextSelectedInputs();

    public static interface SelectionChangedListener {
        public void notifySelectionChanged();
    }

    public static class EdgeInputSelection
    implements InputSelection {
        private final StreamEdge streamEdge;

        private EdgeInputSelection(StreamEdge streamEdge) {
            this.streamEdge = (StreamEdge)Preconditions.checkNotNull((Object)streamEdge);
        }

        public StreamEdge getStreamEdge() {
            return this.streamEdge;
        }

        @Override
        public InputType getInputType() {
            return InputType.EDGE;
        }

        @Override
        public SourceInputSelection toSourceInputSelection() {
            throw new UnsupportedOperationException("This is not a SourceInputSelection");
        }

        @Override
        public EdgeInputSelection toEdgeInputSelection() {
            return this;
        }

        public static EdgeInputSelection create(StreamEdge streamEdge) {
            return new EdgeInputSelection(streamEdge);
        }

        public int hashCode() {
            return Objects.hash(this.streamEdge);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && obj.getClass() == this.getClass()) {
                EdgeInputSelection other = (EdgeInputSelection)obj;
                return other.getStreamEdge().equals(this.streamEdge);
            }
            return false;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("streamEdge", (Object)this.streamEdge).toString();
        }
    }

    public static class SourceInputSelection
    implements InputSelection {
        private final int sourceOperatorId;

        private SourceInputSelection(int sourceOperatorId) {
            this.sourceOperatorId = sourceOperatorId;
        }

        public int getSourceOperatorId() {
            return this.sourceOperatorId;
        }

        @Override
        public InputType getInputType() {
            return InputType.SOURCE;
        }

        @Override
        public SourceInputSelection toSourceInputSelection() {
            return this;
        }

        @Override
        public EdgeInputSelection toEdgeInputSelection() {
            throw new UnsupportedOperationException("This is not an EdgeInputSelection");
        }

        public int hashCode() {
            return Objects.hash(new Object[]{InputType.SOURCE, this.sourceOperatorId});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj != null && obj.getClass() == this.getClass()) {
                SourceInputSelection other = (SourceInputSelection)obj;
                return other.getSourceOperatorId() == this.sourceOperatorId;
            }
            return false;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("InputType", (Object)InputType.SOURCE).append("sourceOperatorId", this.sourceOperatorId).toString();
        }

        public static SourceInputSelection create(int sourceOperatorId) {
            return new SourceInputSelection(sourceOperatorId);
        }
    }

    public static interface InputSelection {
        public InputType getInputType();

        public SourceInputSelection toSourceInputSelection();

        public EdgeInputSelection toEdgeInputSelection();
    }

    public static enum InputType {
        SOURCE,
        EDGE;

    }
}

