/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.bundle;

import org.apache.flink.streaming.api.bundle.BundleTrigger;
import org.apache.flink.streaming.api.bundle.BundleTriggerCallback;
import org.apache.flink.util.Preconditions;

public class CountBundleTrigger<T>
implements BundleTrigger<T> {
    private static final long serialVersionUID = -3640028071558094814L;
    private final long maxCount;
    private transient BundleTriggerCallback callback;
    private transient long count = 0L;

    public CountBundleTrigger(long maxCount) {
        Preconditions.checkArgument((maxCount > 0L ? 1 : 0) != 0, (Object)"blink.miniBatch.size must be greater than 0.");
        this.maxCount = maxCount;
    }

    @Override
    public void registerBundleTriggerCallback(BundleTriggerCallback callback) {
        this.callback = (BundleTriggerCallback)Preconditions.checkNotNull((Object)callback, (String)"callback is null");
    }

    @Override
    public void onElement(T element) throws Exception {
        ++this.count;
        if (this.count >= this.maxCount) {
            this.callback.finishBundle();
        }
    }

    @Override
    public void reset() {
        this.count = 0L;
    }

    @Override
    public String explain() {
        return "CountCountBundleTriggerer with triggerSize is " + this.maxCount;
    }
}

