/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import org.apache.flink.annotation.Public;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.operators.StreamSourceV2;
import org.apache.flink.streaming.api.transformations.SourceV2Transformation;

@Public
public class DataStreamSourceV2<T>
extends SingleOutputStreamOperator<T> {
    boolean isParallel;

    public DataStreamSourceV2(StreamExecutionEnvironment environment, TypeInformation<T> outTypeInfo, StreamSourceV2<T, ?> operator, boolean isParallel, String sourceName) {
        super(environment, new SourceV2Transformation<T>(sourceName, operator, outTypeInfo, environment.getParallelism()));
        this.isParallel = isParallel;
        if (!isParallel) {
            this.setMaxParallelism(1);
            this.setParallelism(1);
        }
    }

    public DataStreamSourceV2(SingleOutputStreamOperator<T> operator) {
        super(operator.environment, operator.getTransformation());
        this.isParallel = true;
    }

    @Override
    public DataStreamSourceV2<T> setParallelism(int parallelism) {
        if (parallelism != 1 && !this.isParallel) {
            throw new IllegalArgumentException("Source: " + this.transformation.getId() + " is not a parallel source");
        }
        super.setParallelism(parallelism);
        return this;
    }
}

