/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.datastream;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.InvalidTypesException;
import org.apache.flink.api.common.operators.ResourceConstraints;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.api.common.typeinfo.TypeHint;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.TypeInfoParser;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.streaming.api.collector.selector.OutputSelector;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SplitStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.transformations.SideOutputTransformation;
import org.apache.flink.streaming.api.transformations.StreamTransformation;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

@Public
public class SingleOutputStreamOperator<T>
extends DataStream<T> {
    protected boolean nonParallel = false;
    private Map<OutputTag<?>, TypeInformation> requestedSideOutputs = new HashMap();
    private boolean wasSplitApplied = false;

    protected SingleOutputStreamOperator(StreamExecutionEnvironment environment, StreamTransformation<T> transformation) {
        super(environment, transformation);
    }

    public String getName() {
        return this.transformation.getName();
    }

    public SingleOutputStreamOperator<T> name(String name) {
        this.transformation.setName(name);
        return this;
    }

    @PublicEvolving
    public SingleOutputStreamOperator<T> uid(String uid) {
        this.transformation.setUid(uid);
        return this;
    }

    @PublicEvolving
    public SingleOutputStreamOperator<T> setUidHash(String uidHash) {
        this.transformation.setUidHash(uidHash);
        return this;
    }

    public SingleOutputStreamOperator<T> setParallelism(int parallelism) {
        Preconditions.checkArgument((this.canBeParallel() || parallelism == 1 ? 1 : 0) != 0, (Object)"The parallelism of non parallel operator must be 1.");
        this.transformation.setParallelism(parallelism);
        return this;
    }

    @PublicEvolving
    public SingleOutputStreamOperator<T> setMaxParallelism(int maxParallelism) {
        Preconditions.checkArgument((maxParallelism > 0 ? 1 : 0) != 0, (Object)"The maximum parallelism must be greater than 0.");
        Preconditions.checkArgument((this.canBeParallel() || maxParallelism == 1 ? 1 : 0) != 0, (Object)"The maximum parallelism of non parallel operator must be 1.");
        this.transformation.setMaxParallelism(maxParallelism);
        return this;
    }

    public SingleOutputStreamOperator<T> setResources(ResourceSpec minResources, ResourceSpec preferredResources) {
        Preconditions.checkNotNull((Object)minResources, (String)"The min resources must be not null.");
        Preconditions.checkNotNull((Object)preferredResources, (String)"The preferred resources must be not null.");
        Preconditions.checkArgument((minResources.isValid() && preferredResources.isValid() && minResources.lessThanOrEqual(preferredResources) ? 1 : 0) != 0, (Object)"The values in resources must be not less than 0 and the preferred resources must be greater than the min resources.");
        this.transformation.setResources(minResources, preferredResources);
        return this;
    }

    public SingleOutputStreamOperator<T> setResources(ResourceSpec resources) {
        Preconditions.checkNotNull((Object)resources, (String)"The resources must be not null.");
        Preconditions.checkArgument((boolean)resources.isValid(), (Object)"The values in resources must be not less than 0.");
        this.transformation.setResources(resources, resources);
        return this;
    }

    public SingleOutputStreamOperator<T> setResourceConstraints(ResourceConstraints constraints) {
        this.transformation.setResourceConstraints(constraints);
        return this;
    }

    private boolean canBeParallel() {
        return !this.nonParallel;
    }

    @PublicEvolving
    public SingleOutputStreamOperator<T> forceNonParallel() {
        this.transformation.setParallelism(1);
        this.transformation.setMaxParallelism(1);
        this.nonParallel = true;
        return this;
    }

    public SingleOutputStreamOperator<T> setBufferTimeout(long timeoutMillis) {
        Preconditions.checkArgument((timeoutMillis >= -1L ? 1 : 0) != 0, (Object)"timeout must be >= -1");
        this.transformation.setBufferTimeout(timeoutMillis);
        return this;
    }

    @PublicEvolving
    private SingleOutputStreamOperator<T> setChainingStrategy(ChainingStrategy strategy) {
        this.transformation.setChainingStrategy(strategy);
        return this;
    }

    @PublicEvolving
    public SingleOutputStreamOperator<T> disableChaining() {
        return this.setChainingStrategy(ChainingStrategy.NEVER);
    }

    @PublicEvolving
    public SingleOutputStreamOperator<T> startNewChain() {
        return this.setChainingStrategy(ChainingStrategy.HEAD);
    }

    public SingleOutputStreamOperator<T> returns(Class<T> typeClass) {
        Objects.requireNonNull(typeClass, "type class must not be null.");
        try {
            return this.returns(TypeInformation.of(typeClass));
        }
        catch (InvalidTypesException e) {
            throw new InvalidTypesException("Cannot infer the type information from the class alone.This is most likely because the class represents a generic type. In that case,please use the 'returns(TypeHint)' method instead.");
        }
    }

    public SingleOutputStreamOperator<T> returns(TypeHint<T> typeHint) {
        Objects.requireNonNull(typeHint, "TypeHint must not be null");
        try {
            return this.returns(TypeInformation.of(typeHint));
        }
        catch (InvalidTypesException e) {
            throw new InvalidTypesException("Cannot infer the type information from the type hint. Make sure that the TypeHint does not use any generic type variables.");
        }
    }

    public SingleOutputStreamOperator<T> returns(TypeInformation<T> typeInfo) {
        Objects.requireNonNull(typeInfo, "TypeInformation must not be null");
        this.transformation.setOutputType(typeInfo);
        return this;
    }

    @Deprecated
    @PublicEvolving
    public SingleOutputStreamOperator<T> returns(String typeInfoString) {
        if (typeInfoString == null) {
            throw new IllegalArgumentException("Type information string must not be null.");
        }
        return this.returns(TypeInfoParser.parse((String)typeInfoString));
    }

    @PublicEvolving
    public SingleOutputStreamOperator<T> slotSharingGroup(String slotSharingGroup) {
        this.transformation.setSlotSharingGroup(slotSharingGroup);
        return this;
    }

    @Override
    public SplitStream<T> split(OutputSelector<T> outputSelector) {
        if (this.requestedSideOutputs.isEmpty()) {
            this.wasSplitApplied = true;
            return super.split(outputSelector);
        }
        throw new UnsupportedOperationException("getSideOutput() and split() may not be called on the same DataStream. As a work-around, please add a no-op map function before the split() call.");
    }

    public <X> DataStream<X> getSideOutput(OutputTag<X> sideOutputTag) {
        if (this.wasSplitApplied) {
            throw new UnsupportedOperationException("getSideOutput() and split() may not be called on the same DataStream. As a work-around, please add a no-op map function before the split() call.");
        }
        sideOutputTag = this.clean(Objects.requireNonNull(sideOutputTag));
        TypeInformation type = this.requestedSideOutputs.get(sideOutputTag = new OutputTag(sideOutputTag.getId(), sideOutputTag.getTypeInfo()));
        if (type != null && !type.equals((Object)sideOutputTag.getTypeInfo())) {
            throw new UnsupportedOperationException("A side output with a matching id was already requested with a different type. This is not allowed, side output ids need to be unique.");
        }
        this.requestedSideOutputs.put(sideOutputTag, sideOutputTag.getTypeInfo());
        SideOutputTransformation sideOutputTransformation = new SideOutputTransformation(this.getTransformation(), sideOutputTag);
        return new DataStream(this.getExecutionEnvironment(), sideOutputTransformation);
    }

    @PublicEvolving
    public SingleOutputStreamOperator<T> setConfigItem(ConfigOption<String> key, String value) {
        this.transformation.getCustomConfiguration().setString(key, value);
        return this;
    }

    public SingleOutputStreamOperator<T> setConfigItem(String key, String value) {
        this.transformation.getCustomConfiguration().setString(key, value);
        return this;
    }
}

