/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.source;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.io.RichInputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.metrics.Counter;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProviderException;
import org.apache.flink.streaming.api.functions.source.RichParallelSourceFunctionV2;
import org.apache.flink.streaming.api.functions.source.SourceRecord;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class InputFormatSourceFunctionV2<OUT>
extends RichParallelSourceFunctionV2<OUT> {
    private static final Logger LOG = LoggerFactory.getLogger(InputFormatSourceFunctionV2.class);
    private static final long serialVersionUID = 1L;
    private TypeInformation<OUT> typeInfo;
    private transient TypeSerializer<OUT> serializer;
    private InputFormat<OUT, InputSplit> format;
    private transient StreamingRuntimeContext context;
    private transient InputSplitProvider provider;
    private transient Iterator<InputSplit> splitIterator;
    private transient Counter completedSplitsCounter;
    private transient OUT reusableElement;
    private transient SourceRecord<OUT> sourceRecord;
    private transient boolean isObjectReuse;
    private transient boolean hasMoreData;
    private transient long afterOpen;

    public InputFormatSourceFunctionV2(InputFormat<OUT, ?> format, TypeInformation<OUT> typeInfo) {
        this.format = format;
        this.typeInfo = typeInfo;
    }

    public void open(Configuration parameters) throws Exception {
        this.context = (StreamingRuntimeContext)this.getRuntimeContext();
        if (this.format instanceof RichInputFormat) {
            ((RichInputFormat)this.format).setRuntimeContext((RuntimeContext)this.context);
        }
        this.format.configure(parameters);
        this.provider = this.context.getInputSplitProvider();
        this.serializer = this.typeInfo.createSerializer(this.getRuntimeContext().getExecutionConfig());
        this.splitIterator = this.getInputSplits();
        this.completedSplitsCounter = this.getRuntimeContext().getMetricGroup().counter("numSplitsProcessed");
        if (this.format instanceof RichInputFormat) {
            ((RichInputFormat)this.format).openInputFormat();
        }
        long beforeNext = System.currentTimeMillis();
        this.hasMoreData = this.splitIterator.hasNext();
        long afterNext = System.currentTimeMillis();
        LOG.info("get input split from splitProvider, elapsed time: " + (afterNext - beforeNext));
        if (this.hasMoreData) {
            long beforeOpen = System.currentTimeMillis();
            this.format.open(this.splitIterator.next());
            this.afterOpen = System.currentTimeMillis();
            LOG.info("open the format, elapsed time: " + (this.afterOpen - beforeOpen));
        }
        this.isObjectReuse = this.getRuntimeContext().getExecutionConfig().isObjectReuseEnabled();
        this.sourceRecord = new SourceRecord();
        this.reusableElement = this.serializer.createInstance();
    }

    @Override
    public boolean isFinished() {
        return !this.hasMoreData;
    }

    @Override
    public SourceRecord<OUT> next() throws Exception {
        while (this.hasMoreData) {
            if (!this.format.reachedEnd()) {
                Object element = this.format.nextRecord(this.reusableElement);
                if (element != null) {
                    this.reusableElement = element;
                    this.sourceRecord.setRecord(element);
                    return this.sourceRecord;
                }
                this.completedSplitsCounter.inc();
                this.requestNextSplit();
                continue;
            }
            this.requestNextSplit();
        }
        return null;
    }

    @Override
    public void cancel() {
    }

    private void requestNextSplit() throws IOException {
        long b1 = System.currentTimeMillis();
        LOG.info("do a split, cost: " + (b1 - this.afterOpen));
        this.format.close();
        long b2 = System.currentTimeMillis();
        LOG.info("close a split, cost: " + (b2 - b1));
        if (this.splitIterator.hasNext()) {
            long b3 = System.currentTimeMillis();
            LOG.info("get input split from splitProvider, elapsed time: " + (b3 - b2));
            this.format.open(this.splitIterator.next());
            this.afterOpen = System.currentTimeMillis();
            LOG.info("open the format, elapsed time: " + (this.afterOpen - b3));
        } else {
            long b3 = System.currentTimeMillis();
            LOG.info("get input split from splitProvider, elapsed time: " + (b3 - b2));
            this.hasMoreData = false;
        }
    }

    public void close() throws Exception {
        if (this.format != null) {
            this.format.close();
            if (this.format instanceof RichInputFormat) {
                ((RichInputFormat)this.format).closeInputFormat();
            }
            this.format = null;
        }
    }

    public InputFormat<OUT, InputSplit> getFormat() {
        return this.format;
    }

    private Iterator<InputSplit> getInputSplits() {
        return new Iterator<InputSplit>(){
            private InputSplit nextSplit;
            private boolean exhausted;

            @Override
            public boolean hasNext() {
                InputSplit split;
                if (this.exhausted) {
                    return false;
                }
                if (this.nextSplit != null) {
                    return true;
                }
                try {
                    split = InputFormatSourceFunctionV2.this.provider.getNextInputSplit(InputFormatSourceFunctionV2.this.context.getOperatorID(), InputFormatSourceFunctionV2.this.context.getUserCodeClassLoader());
                }
                catch (InputSplitProviderException e) {
                    throw new RuntimeException("Could not retrieve next input split.", e);
                }
                if (split != null) {
                    this.nextSplit = split;
                    return true;
                }
                this.exhausted = true;
                return false;
            }

            @Override
            public InputSplit next() {
                if (this.nextSplit == null && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                InputSplit tmp = this.nextSplit;
                this.nextSplit = null;
                return tmp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

