/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.io.network.DataExchangeMode;
import org.apache.flink.runtime.jobgraph.EdgeID;
import org.apache.flink.runtime.operators.DamBehavior;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.graph.StreamSchedulingMode;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.util.OutputTag;

@Internal
public class StreamEdge
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final EdgeID edgeID;
    private final String edgeName;
    private final int sourceId;
    private final int targetId;
    private final int typeNumber;
    private final List<String> selectedNames;
    private final OutputTag outputTag;
    private final boolean isAutoPartitioner;
    private StreamPartitioner<?> outputPartitioner;
    private DataExchangeMode dataExchangeMode;
    private final DamBehavior damBehavior;
    private StreamSchedulingMode schedulingMode;

    @VisibleForTesting
    public StreamEdge(StreamNode sourceVertex, StreamNode targetVertex, int typeNumber, List<String> selectedNames, StreamPartitioner<?> outputPartitioner, OutputTag outputTag) {
        this(sourceVertex, targetVertex, typeNumber, selectedNames, false, outputPartitioner, outputTag, DataExchangeMode.PIPELINED, DamBehavior.PIPELINED);
    }

    public StreamEdge(StreamNode sourceVertex, StreamNode targetVertex, int typeNumber, List<String> selectedNames, boolean isAutoPartitioner, StreamPartitioner<?> outputPartitioner, OutputTag outputTag, DataExchangeMode dataExchangeMode, DamBehavior damBehavior) {
        this.sourceId = sourceVertex.getId();
        this.targetId = targetVertex.getId();
        this.typeNumber = typeNumber;
        this.selectedNames = selectedNames;
        this.isAutoPartitioner = isAutoPartitioner;
        this.outputPartitioner = outputPartitioner;
        this.outputTag = outputTag;
        this.dataExchangeMode = dataExchangeMode;
        this.damBehavior = damBehavior;
        this.edgeID = new EdgeID();
        this.edgeName = sourceVertex + "_" + targetVertex + "_" + typeNumber + "_" + selectedNames + "_" + outputPartitioner;
    }

    public EdgeID getEdgeID() {
        return this.edgeID;
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public int getTargetId() {
        return this.targetId;
    }

    public int getTypeNumber() {
        return this.typeNumber;
    }

    public List<String> getSelectedNames() {
        return this.selectedNames;
    }

    public OutputTag getOutputTag() {
        return this.outputTag;
    }

    public StreamPartitioner<?> getPartitioner() {
        return this.outputPartitioner;
    }

    public DataExchangeMode getDataExchangeMode() {
        return this.dataExchangeMode;
    }

    public DamBehavior getDamBehavior() {
        return this.damBehavior;
    }

    public StreamSchedulingMode getSchedulingMode() {
        return this.schedulingMode;
    }

    public boolean isAutoPartitioner() {
        return this.isAutoPartitioner;
    }

    public void setPartitioner(StreamPartitioner<?> partitioner) {
        this.outputPartitioner = partitioner;
    }

    public void setDataExchangeMode(DataExchangeMode dataExchangeMode) {
        this.dataExchangeMode = dataExchangeMode;
    }

    public void setSchedulingMode(StreamSchedulingMode schedulingMode) {
        this.schedulingMode = schedulingMode;
    }

    public int hashCode() {
        return Objects.hash(this.edgeName, this.edgeID);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamEdge that = (StreamEdge)o;
        return this.edgeName.equals(that.edgeName) && this.edgeID.equals((Object)that.getEdgeID());
    }

    public String toString() {
        return "(" + this.sourceId + " -> " + this.targetId + ", typeNumber=" + this.typeNumber + ", selectedNames=" + this.selectedNames + ", outputPartitioner=" + this.outputPartitioner + ", isAutoPartitioner=" + this.isAutoPartitioner + ", outputTag=" + this.outputTag + ", dataExchangeMode=" + this.dataExchangeMode + ", edgeID=" + this.edgeID + ')';
    }
}

