/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.accumulators.AbstractAccumulatorRegistry;
import org.apache.flink.api.common.functions.BroadcastVariableInitializer;
import org.apache.flink.api.common.functions.util.AbstractRuntimeUDFContext;
import org.apache.flink.api.common.state.AggregatingState;
import org.apache.flink.api.common.state.AggregatingStateDescriptor;
import org.apache.flink.api.common.state.FoldingState;
import org.apache.flink.api.common.state.FoldingStateDescriptor;
import org.apache.flink.api.common.state.KeyedStateStore;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ReducingState;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.SortedMapState;
import org.apache.flink.api.common.state.SortedMapStateDescriptor;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.util.Preconditions;

@Internal
public class StreamingRuntimeContext
extends AbstractRuntimeUDFContext {
    private final AbstractStreamOperator<?> operator;
    private final Environment taskEnvironment;
    private final StreamConfig streamConfig;
    private final String operatorUniqueID;

    public StreamingRuntimeContext(AbstractStreamOperator<?> operator, Environment env) {
        super(env.getTaskInfo(), env.getUserClassLoader(), operator.getExecutionConfig(), (AbstractAccumulatorRegistry)env.getAccumulatorRegistry(), env.getDistributedCacheEntries(), (MetricGroup)operator.getMetricGroup());
        this.operator = operator;
        this.taskEnvironment = env;
        this.streamConfig = new StreamConfig(env.getTaskConfiguration());
        this.operatorUniqueID = operator.getOperatorID().toString();
    }

    public InputSplitProvider getInputSplitProvider() {
        return this.taskEnvironment.getInputSplitProvider();
    }

    public ProcessingTimeService getProcessingTimeService() {
        return this.operator.getProcessingTimeService();
    }

    public String getOperatorUniqueID() {
        return this.operatorUniqueID;
    }

    public OperatorID getOperatorID() {
        return this.operator.getOperatorID();
    }

    public boolean hasBroadcastVariable(String name) {
        throw new UnsupportedOperationException("Broadcast variables can only be used in DataSet programs");
    }

    public <RT> List<RT> getBroadcastVariable(String name) {
        throw new UnsupportedOperationException("Broadcast variables can only be used in DataSet programs");
    }

    public <T, C> C getBroadcastVariableWithInitializer(String name, BroadcastVariableInitializer<T, C> initializer) {
        throw new UnsupportedOperationException("Broadcast variables can only be used in DataSet programs");
    }

    public <T> ValueState<T> getState(ValueStateDescriptor<T> stateProperties) {
        KeyedStateStore keyedStateStore = this.checkPreconditionsAndGetKeyedStateStore((StateDescriptor<?, ?>)stateProperties);
        return keyedStateStore.getState(stateProperties);
    }

    public <T> ListState<T> getListState(ListStateDescriptor<T> stateProperties) {
        KeyedStateStore keyedStateStore = this.checkPreconditionsAndGetKeyedStateStore((StateDescriptor<?, ?>)stateProperties);
        return keyedStateStore.getListState(stateProperties);
    }

    public <T> ReducingState<T> getReducingState(ReducingStateDescriptor<T> stateProperties) {
        KeyedStateStore keyedStateStore = this.checkPreconditionsAndGetKeyedStateStore((StateDescriptor<?, ?>)stateProperties);
        return keyedStateStore.getReducingState(stateProperties);
    }

    public <IN, ACC, OUT> AggregatingState<IN, OUT> getAggregatingState(AggregatingStateDescriptor<IN, ACC, OUT> stateProperties) {
        KeyedStateStore keyedStateStore = this.checkPreconditionsAndGetKeyedStateStore((StateDescriptor<?, ?>)stateProperties);
        return keyedStateStore.getAggregatingState(stateProperties);
    }

    public <T, ACC> FoldingState<T, ACC> getFoldingState(FoldingStateDescriptor<T, ACC> stateProperties) {
        KeyedStateStore keyedStateStore = this.checkPreconditionsAndGetKeyedStateStore((StateDescriptor<?, ?>)stateProperties);
        return keyedStateStore.getFoldingState(stateProperties);
    }

    public <UK, UV> MapState<UK, UV> getMapState(MapStateDescriptor<UK, UV> stateProperties) {
        KeyedStateStore keyedStateStore = this.checkPreconditionsAndGetKeyedStateStore((StateDescriptor<?, ?>)stateProperties);
        return keyedStateStore.getMapState(stateProperties);
    }

    public <UK, UV> SortedMapState<UK, UV> getSortedMapState(SortedMapStateDescriptor<UK, UV> stateProperties) {
        KeyedStateStore keyedStateStore = this.checkPreconditionsAndGetKeyedStateStore((StateDescriptor<?, ?>)stateProperties);
        return keyedStateStore.getSortedMapState(stateProperties);
    }

    private KeyedStateStore checkPreconditionsAndGetKeyedStateStore(StateDescriptor<?, ?> stateDescriptor) {
        Preconditions.checkNotNull(stateDescriptor, (String)"The state properties must not be null");
        KeyedStateStore keyedStateStore = this.operator.getKeyedStateStore();
        Preconditions.checkNotNull((Object)keyedStateStore, (String)"Keyed state can only be used on a 'keyed stream', i.e., after a 'keyBy()' operation.");
        return keyedStateStore;
    }

    public boolean isCheckpointingEnabled() {
        return this.streamConfig.isCheckpointingEnabled();
    }

    public CheckpointingMode getCheckpointMode() {
        return this.streamConfig.getCheckpointMode();
    }

    public long getBufferTimeout() {
        return this.streamConfig.getBufferTimeout();
    }
}

