/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.api.operators.TimerHeapInternalTimer;
import org.apache.flink.util.MathUtils;

public class TimerSerializer<K, N>
extends TypeSerializer<TimerHeapInternalTimer<K, N>> {
    private static final long serialVersionUID = 1L;
    @Nonnull
    private final TypeSerializer<K> keySerializer;
    @Nonnull
    private final TypeSerializer<N> namespaceSerializer;
    private final int length;
    private final boolean immutableType;

    TimerSerializer(@Nonnull TypeSerializer<K> keySerializer, @Nonnull TypeSerializer<N> namespaceSerializer) {
        this(keySerializer, namespaceSerializer, TimerSerializer.computeTotalByteLength(keySerializer, namespaceSerializer), keySerializer.isImmutableType() && namespaceSerializer.isImmutableType());
    }

    private TimerSerializer(@Nonnull TypeSerializer<K> keySerializer, @Nonnull TypeSerializer<N> namespaceSerializer, int length, boolean immutableType) {
        this.keySerializer = keySerializer;
        this.namespaceSerializer = namespaceSerializer;
        this.length = length;
        this.immutableType = immutableType;
    }

    private static int computeTotalByteLength(TypeSerializer<?> keySerializer, TypeSerializer<?> namespaceSerializer) {
        if (keySerializer.getLength() >= 0 && namespaceSerializer.getLength() >= 0) {
            return 8 + keySerializer.getLength() + namespaceSerializer.getLength();
        }
        return -1;
    }

    public boolean isImmutableType() {
        return this.immutableType;
    }

    public TimerSerializer<K, N> duplicate() {
        TypeSerializer keySerializerDuplicate = this.keySerializer.duplicate();
        TypeSerializer namespaceSerializerDuplicate = this.namespaceSerializer.duplicate();
        if (keySerializerDuplicate == this.keySerializer && namespaceSerializerDuplicate == this.namespaceSerializer) {
            return this;
        }
        return new TimerSerializer<K, N>(keySerializerDuplicate, namespaceSerializerDuplicate, this.length, this.immutableType);
    }

    public TimerHeapInternalTimer<K, N> createInstance() {
        return new TimerHeapInternalTimer<Object, Object>(0L, this.keySerializer.createInstance(), this.namespaceSerializer.createInstance());
    }

    public TimerHeapInternalTimer<K, N> copy(TimerHeapInternalTimer<K, N> from) {
        Object namespaceDuplicate;
        Object keyDuplicate;
        if (this.isImmutableType()) {
            keyDuplicate = from.getKey();
            namespaceDuplicate = from.getNamespace();
        } else {
            keyDuplicate = this.keySerializer.copy(from.getKey());
            namespaceDuplicate = this.namespaceSerializer.copy(from.getNamespace());
        }
        return new TimerHeapInternalTimer<K, N>(from.getTimestamp(), keyDuplicate, namespaceDuplicate);
    }

    public TimerHeapInternalTimer<K, N> copy(TimerHeapInternalTimer<K, N> from, TimerHeapInternalTimer<K, N> reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return this.length;
    }

    public void serialize(TimerHeapInternalTimer<K, N> record, DataOutputView target) throws IOException {
        target.writeLong(MathUtils.flipSignBit((long)record.getTimestamp()));
        this.keySerializer.serialize(record.getKey(), target);
        this.namespaceSerializer.serialize(record.getNamespace(), target);
    }

    public TimerHeapInternalTimer<K, N> deserialize(DataInputView source) throws IOException {
        long timestamp = MathUtils.flipSignBit((long)source.readLong());
        Object key = this.keySerializer.deserialize(source);
        Object namespace = this.namespaceSerializer.deserialize(source);
        return new TimerHeapInternalTimer<Object, Object>(timestamp, key, namespace);
    }

    public TimerHeapInternalTimer<K, N> deserialize(TimerHeapInternalTimer<K, N> reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        target.writeLong(source.readLong());
        this.keySerializer.copy(source, target);
        this.namespaceSerializer.copy(source, target);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TimerSerializer that = (TimerSerializer)((Object)o);
        return Objects.equals(this.keySerializer, that.keySerializer) && Objects.equals(this.namespaceSerializer, that.namespaceSerializer);
    }

    public int hashCode() {
        return Objects.hash(this.keySerializer, this.namespaceSerializer);
    }

    public boolean canEqual(Object obj) {
        return obj instanceof TimerSerializer;
    }

    public TypeSerializerConfigSnapshot snapshotConfiguration() {
        return new TimerSerializerConfigSnapshot<K, N>(this.keySerializer, this.namespaceSerializer);
    }

    public CompatibilityResult<TimerHeapInternalTimer<K, N>> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        return CompatibilityResult.compatible();
    }

    @Nonnull
    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    @Nonnull
    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    public static class TimerSerializerConfigSnapshot<K, N>
    extends CompositeTypeSerializerConfigSnapshot {
        public TimerSerializerConfigSnapshot() {
        }

        public TimerSerializerConfigSnapshot(TypeSerializer<K> keySerializer, TypeSerializer<N> namespaceSerializer) {
            super(new TypeSerializer[]{keySerializer, namespaceSerializer});
        }

        public int getVersion() {
            return 0;
        }
    }
}

