/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.transformations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.flink.runtime.operators.DamBehavior;
import org.apache.flink.shaded.guava18.com.google.common.collect.Lists;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.transformations.StreamTransformation;
import org.apache.flink.util.OutputTag;

public class SideOutputTransformation<T>
extends StreamTransformation<T> {
    private final StreamTransformation<?> input;
    private final OutputTag<T> tag;
    private DamBehavior damBehavior;

    public SideOutputTransformation(StreamTransformation<?> input, OutputTag<T> tag) {
        super("SideOutput", tag.getTypeInfo(), Objects.requireNonNull(input).getParallelism());
        this.input = input;
        this.tag = Objects.requireNonNull(tag);
    }

    public StreamTransformation<?> getInput() {
        return this.input;
    }

    public OutputTag<T> getOutputTag() {
        return this.tag;
    }

    @Override
    public Collection<StreamTransformation<?>> getTransitivePredecessors() {
        ArrayList result = Lists.newArrayList();
        result.add(this);
        result.addAll(this.input.getTransitivePredecessors());
        return result;
    }

    @Override
    public final void setChainingStrategy(ChainingStrategy strategy) {
        throw new UnsupportedOperationException("Cannot set chaining strategy on SideOutput Transformation.");
    }

    public DamBehavior getDamBehavior() {
        return this.damBehavior;
    }

    public void setDamBehavior(DamBehavior damBehavior) {
        this.damBehavior = damBehavior;
    }
}

