/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.calcite.plan.MaterializedViewSubstitutionVisitor;
import org.apache.calcite.plan.RelOptLattice;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.graph.DefaultDirectedGraph;
import org.apache.calcite.util.graph.DefaultEdge;
import org.apache.calcite.util.graph.Graphs;
import org.apache.calcite.util.graph.TopologicalOrderIterator;
import org.apache.flink.shaded.calcite.com.google.common.base.Suppliers;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableCollection;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.calcite.com.google.common.collect.Iterables;
import org.apache.flink.shaded.calcite.com.google.common.collect.Sets;

public abstract class RelOptMaterializations {
    public static List<Pair<RelNode, List<RelOptMaterialization>>> useMaterializedViews(RelNode rel, List<RelOptMaterialization> materializations) {
        List<RelOptMaterialization> applicableMaterializations = RelOptMaterializations.getApplicableMaterializations(rel, materializations);
        ArrayList<Pair<RelNode, ImmutableCollection>> applied = new ArrayList<Pair<RelNode, ImmutableCollection>>();
        applied.add(Pair.of(rel, ImmutableList.of()));
        for (RelOptMaterialization m : applicableMaterializations) {
            int count = applied.size();
            for (int i = 0; i < count; ++i) {
                Pair current = (Pair)applied.get(i);
                List<RelNode> sub = RelOptMaterializations.substitute((RelNode)current.left, m);
                if (sub.isEmpty()) continue;
                ImmutableList.Builder builder = ImmutableList.builder();
                builder.addAll((Iterable)current.right);
                builder.add(m);
                ImmutableCollection uses = builder.build();
                for (RelNode rel2 : sub) {
                    applied.add(Pair.of(rel2, uses));
                }
            }
        }
        return applied.subList(1, applied.size());
    }

    public static List<Pair<RelNode, RelOptLattice>> useLattices(RelNode rel, List<RelOptLattice> lattices) {
        Set<RelOptTable> queryTables = RelOptUtil.findTables(rel);
        ArrayList<Pair<RelNode, RelOptLattice>> latticeUses = new ArrayList<Pair<RelNode, RelOptLattice>>();
        HashSet queryTableNames = Sets.newHashSet(Iterables.transform(queryTables, RelOptTable::getQualifiedName));
        Supplier<RelNode> leafJoinRoot = Suppliers.memoize(() -> RelOptMaterialization.toLeafJoinForm(rel))::get;
        for (RelOptLattice lattice : lattices) {
            RelNode rel2;
            if (!queryTableNames.contains(lattice.rootTable().getQualifiedName()) || (rel2 = lattice.rewrite(leafJoinRoot.get())) == null) continue;
            if (CalcitePrepareImpl.DEBUG) {
                System.out.println("use lattice:\n" + RelOptUtil.toString(rel2));
            }
            latticeUses.add(Pair.of(rel2, lattice));
        }
        return latticeUses;
    }

    public static List<RelOptMaterialization> getApplicableMaterializations(RelNode rel, List<RelOptMaterialization> materializations) {
        DefaultDirectedGraph<List<String>, DefaultEdge> usesGraph = DefaultDirectedGraph.create();
        HashMap<List<String>, RelOptMaterialization> qnameMap = new HashMap<List<String>, RelOptMaterialization>();
        for (RelOptMaterialization materialization : materializations) {
            if (materialization.qualifiedTableName == null || materialization.starTable != null) continue;
            List<String> qname = materialization.qualifiedTableName;
            qnameMap.put(qname, materialization);
            for (RelOptTable usedTable : RelOptUtil.findTables(materialization.queryRel)) {
                usesGraph.addVertex(qname);
                usesGraph.addVertex(usedTable.getQualifiedName());
                usesGraph.addEdge(usedTable.getQualifiedName(), qname);
            }
        }
        Graphs.FrozenGraph<List<String>, DefaultEdge> frozenGraph = Graphs.makeImmutable(usesGraph);
        Set<RelOptTable> queryTablesUsed = RelOptUtil.findTables(rel);
        ArrayList<RelOptMaterialization> applicableMaterializations = new ArrayList<RelOptMaterialization>();
        for (List qname : TopologicalOrderIterator.of(usesGraph)) {
            RelOptMaterialization materialization = (RelOptMaterialization)qnameMap.get(qname);
            if (materialization == null || !RelOptMaterializations.usesTable(materialization.qualifiedTableName, queryTablesUsed, frozenGraph)) continue;
            applicableMaterializations.add(materialization);
        }
        return applicableMaterializations;
    }

    private static List<RelNode> substitute(RelNode root, RelOptMaterialization materialization) {
        RelNode newRoot;
        if (materialization.starTable != null && (newRoot = RelOptMaterialization.tryUseStar(root, materialization.starRelOptTable)) != null) {
            root = newRoot;
        }
        RelNode target = materialization.queryRel;
        HepProgram program = new HepProgramBuilder().addRuleInstance(FilterProjectTransposeRule.INSTANCE).addRuleInstance(ProjectMergeRule.INSTANCE).addRuleInstance(ProjectRemoveRule.INSTANCE).build();
        HepPlanner hepPlanner = new HepPlanner(program);
        hepPlanner.setRoot(target);
        target = hepPlanner.findBestExp();
        hepPlanner.setRoot(root);
        root = hepPlanner.findBestExp();
        return new MaterializedViewSubstitutionVisitor(target, root).go(materialization.tableRel);
    }

    private static boolean usesTable(List<String> qualifiedName, Set<RelOptTable> usedTables, Graphs.FrozenGraph<List<String>, DefaultEdge> usesGraph) {
        for (RelOptTable queryTable : usedTables) {
            if (usesGraph.getShortestPath(queryTable.getQualifiedName(), qualifiedName) == null) continue;
            return true;
        }
        return false;
    }
}

