/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel;

import java.util.Comparator;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.runtime.Utilities;
import org.apache.flink.shaded.calcite.com.google.common.collect.Ordering;

public class RelNodes {
    public static final Comparator<RelNode> COMPARATOR = new RelNodeComparator();
    public static final Ordering<RelNode> ORDERING = Ordering.from(COMPARATOR);

    private RelNodes() {
    }

    public static int compareRels(RelNode[] rels0, RelNode[] rels1) {
        int c = Utilities.compare(rels0.length, rels1.length);
        if (c != 0) {
            return c;
        }
        for (int i = 0; i < rels0.length; ++i) {
            c = COMPARATOR.compare(rels0[i], rels1[i]);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    private static class RelNodeComparator
    implements Comparator<RelNode> {
        private RelNodeComparator() {
        }

        @Override
        public int compare(RelNode o1, RelNode o2) {
            int c = Utilities.compare(o1.getRowType().getFieldCount(), o2.getRowType().getFieldCount());
            if (c != 0) {
                return -c;
            }
            return Utilities.compare(o1.getId(), o2.getId());
        }
    }
}

