/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.EquiJoin;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Util;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableSet;

public class SemiJoin
extends EquiJoin {
    public final boolean isAnti;

    public SemiJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys, boolean isAnti) {
        super(cluster, traitSet, left, right, condition, leftKeys, rightKeys, ImmutableSet.of(), JoinRelType.INNER);
        this.isAnti = isAnti;
    }

    public static SemiJoin create(RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys, boolean isAnti) {
        RelOptCluster cluster = left.getCluster();
        return new SemiJoin(cluster, cluster.traitSetOf((RelTrait)Convention.NONE), left, right, condition, leftKeys, rightKeys, isAnti);
    }

    @Override
    public SemiJoin copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        assert (joinType == JoinRelType.INNER);
        JoinInfo joinInfo = JoinInfo.of(left, right, condition);
        return new SemiJoin(this.getCluster(), traitSet, left, right, condition, joinInfo.leftKeys, joinInfo.rightKeys, this.isAnti);
    }

    @Override
    public JoinInfo analyzeCondition() {
        return JoinInfo.of(this.left, this.right, this.condition);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeTinyCost();
    }

    @Override
    public double estimateRowCount(RelMetadataQuery mq) {
        return Util.first(RelMdUtil.getSemiJoinRowCount(mq, this.left, this.right, this.joinType, this.condition, this.isAnti), 1.0);
    }

    @Override
    public RelDataType deriveRowType() {
        return SqlValidatorUtil.deriveJoinRowType(this.left.getRowType(), null, JoinRelType.INNER, this.getCluster().getTypeFactory(), null, ImmutableList.of());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("isAnti", this.isAnti);
    }
}

