/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;

public class FilterCorrelateRule
extends RelOptRule {
    public static final FilterCorrelateRule INSTANCE = new FilterCorrelateRule(RelFactories.LOGICAL_BUILDER);

    public FilterCorrelateRule(RelBuilderFactory builderFactory) {
        super(FilterCorrelateRule.operand(Filter.class, FilterCorrelateRule.operand(Correlate.class, RelOptRule.any()), new RelOptRuleOperand[0]), builderFactory, "FilterCorrelateRule");
    }

    @Deprecated
    public FilterCorrelateRule(RelFactories.FilterFactory filterFactory, RelFactories.ProjectFactory projectFactory) {
        this(RelBuilder.proto(filterFactory, projectFactory));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filter = (Filter)call.rel(0);
        Correlate corr = (Correlate)call.rel(1);
        List<RexNode> aboveFilters = RelOptUtil.conjunctions(filter.getCondition());
        ArrayList<RexNode> leftFilters = new ArrayList<RexNode>();
        ArrayList<RexNode> rightFilters = new ArrayList<RexNode>();
        RelOptUtil.classifyFilters(corr, aboveFilters, JoinRelType.INNER, false, !corr.getJoinType().toJoinType().generatesNullsOnLeft(), !corr.getJoinType().toJoinType().generatesNullsOnRight(), aboveFilters, leftFilters, rightFilters);
        if (leftFilters.isEmpty() && rightFilters.isEmpty()) {
            return;
        }
        RexBuilder rexBuilder = corr.getCluster().getRexBuilder();
        RelBuilder relBuilder = call.builder();
        RelNode leftRel = relBuilder.push(corr.getLeft()).filter(leftFilters).build();
        RelNode rightRel = relBuilder.push(corr.getRight()).filter(rightFilters).build();
        RelNode newCorrRel = corr.copy(corr.getTraitSet(), ImmutableList.of(leftRel, rightRel));
        call.getPlanner().onCopy(corr, newCorrRel);
        if (!leftFilters.isEmpty()) {
            call.getPlanner().onCopy(filter, leftRel);
        }
        if (!rightFilters.isEmpty()) {
            call.getPlanner().onCopy(filter, rightRel);
        }
        relBuilder.push(newCorrRel);
        relBuilder.filter(RexUtil.fixUp(rexBuilder, aboveFilters, RelOptUtil.getFieldTypeList(relBuilder.peek().getRowType())));
        call.transformTo(relBuilder.build());
    }
}

