/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableInterpreter;
import org.apache.calcite.interpreter.Bindables;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.flink.shaded.calcite.com.google.common.base.Predicate;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;

public abstract class ProjectTableScanRule
extends RelOptRule {
    @Deprecated
    public static final Predicate<TableScan> PREDICATE = ProjectTableScanRule::test;
    public static final ProjectTableScanRule INSTANCE = new ProjectTableScanRule(ProjectTableScanRule.operand(Project.class, ProjectTableScanRule.operandJ(TableScan.class, null, ProjectTableScanRule::test, ProjectTableScanRule.none()), new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, "ProjectScanRule"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            TableScan scan = (TableScan)call.rel(1);
            this.apply(call, project, scan);
        }
    };
    public static final ProjectTableScanRule INTERPRETER = new ProjectTableScanRule(ProjectTableScanRule.operand(Project.class, ProjectTableScanRule.operand(EnumerableInterpreter.class, ProjectTableScanRule.operandJ(TableScan.class, null, ProjectTableScanRule::test, ProjectTableScanRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, "ProjectScanRule:interpreter"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            TableScan scan = (TableScan)call.rel(2);
            this.apply(call, project, scan);
        }
    };

    public ProjectTableScanRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description) {
        super(operand, relBuilderFactory, description);
    }

    protected static boolean test(TableScan scan) {
        RelOptTable table = scan.getTable();
        return table.unwrap(ProjectableFilterableTable.class) != null;
    }

    protected void apply(RelOptRuleCall call, Project project, TableScan scan) {
        ImmutableIntList projects;
        ImmutableList<RexNode> filters;
        RelOptTable table = scan.getTable();
        assert (table.unwrap(ProjectableFilterableTable.class) != null);
        Mappings.TargetMapping mapping = project.getMapping();
        if (mapping == null || Mappings.isIdentity(mapping)) {
            return;
        }
        if (scan instanceof Bindables.BindableTableScan) {
            Bindables.BindableTableScan bindableScan = (Bindables.BindableTableScan)scan;
            filters = bindableScan.filters;
            projects = bindableScan.projects;
        } else {
            filters = ImmutableList.of();
            projects = scan.identity();
        }
        List<Integer> projects2 = Mappings.apply((Mapping)mapping, projects);
        call.transformTo(Bindables.BindableTableScan.create(scan.getCluster(), scan.getTable(), filters, projects2));
    }
}

