/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.rules.ReduceExpressionsRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.trace.CalciteTrace;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableCollection;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;

public abstract class ValuesReduceRule
extends RelOptRule {
    private static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    public static final ValuesReduceRule FILTER_INSTANCE = new ValuesReduceRule(ValuesReduceRule.operand(LogicalFilter.class, ValuesReduceRule.operandJ(LogicalValues.class, null, Values::isNotEmpty, ValuesReduceRule.none()), new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, "ValuesReduceRule(Filter)"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalFilter filter = (LogicalFilter)call.rel(0);
            LogicalValues values = (LogicalValues)call.rel(1);
            this.apply(call, null, filter, values);
        }
    };
    public static final ValuesReduceRule PROJECT_INSTANCE = new ValuesReduceRule(ValuesReduceRule.operand(LogicalProject.class, ValuesReduceRule.operandJ(LogicalValues.class, null, Values::isNotEmpty, ValuesReduceRule.none()), new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, "ValuesReduceRule(Project)"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalProject project = (LogicalProject)call.rel(0);
            LogicalValues values = (LogicalValues)call.rel(1);
            this.apply(call, project, null, values);
        }
    };
    public static final ValuesReduceRule PROJECT_FILTER_INSTANCE = new ValuesReduceRule(ValuesReduceRule.operand(LogicalProject.class, ValuesReduceRule.operand(LogicalFilter.class, ValuesReduceRule.operandJ(LogicalValues.class, null, Values::isNotEmpty, ValuesReduceRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, "ValuesReduceRule(Project-Filter)"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalProject project = (LogicalProject)call.rel(0);
            LogicalFilter filter = (LogicalFilter)call.rel(1);
            LogicalValues values = (LogicalValues)call.rel(2);
            this.apply(call, project, filter, values);
        }
    };

    public ValuesReduceRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String desc) {
        super(operand, relBuilderFactory, desc);
        Util.discard(LOGGER);
    }

    protected void apply(RelOptRuleCall call, LogicalProject project, LogicalFilter filter, LogicalValues values) {
        assert (values != null);
        assert (filter != null || project != null);
        RexNode conditionExpr = filter == null ? null : filter.getCondition();
        List<RexNode> projectExprs = project == null ? null : project.getProjects();
        RexBuilder rexBuilder = values.getCluster().getRexBuilder();
        ArrayList<RexNode> reducibleExps = new ArrayList<RexNode>();
        MyRexShuttle shuttle = new MyRexShuttle();
        for (List list : values.getTuples()) {
            shuttle.literalList = list;
            if (conditionExpr != null) {
                RexNode c = conditionExpr.accept(shuttle);
                reducibleExps.add(c);
            }
            if (projectExprs == null) continue;
            int k = -1;
            for (RexNode projectExpr : projectExprs) {
                ++k;
                RexNode e2 = projectExpr.accept(shuttle);
                if (RexLiteral.isNullLiteral(e2)) {
                    e2 = rexBuilder.makeAbstractCast(project.getRowType().getFieldList().get(k).getType(), e2);
                }
                reducibleExps.add(e2);
            }
        }
        int fieldsPerRow = (conditionExpr == null ? 0 : 1) + (projectExprs == null ? 0 : projectExprs.size());
        assert (fieldsPerRow > 0);
        assert (reducibleExps.size() == values.getTuples().size() * fieldsPerRow);
        RelOptPredicateList relOptPredicateList = RelOptPredicateList.EMPTY;
        ReduceExpressionsRule.reduceExpressions(values, reducibleExps, relOptPredicateList, false, true);
        int changeCount = 0;
        ImmutableList.Builder tuplesBuilder = ImmutableList.builder();
        for (int row2 = 0; row2 < values.getTuples().size(); ++row2) {
            ImmutableCollection valuesList;
            RexNode reducedValue;
            int i = 0;
            if (conditionExpr != null) {
                reducedValue = (RexNode)reducibleExps.get(row2 * fieldsPerRow + i);
                ++i;
                if (!reducedValue.isAlwaysTrue()) {
                    ++changeCount;
                    continue;
                }
            }
            if (projectExprs != null) {
                ++changeCount;
                ImmutableList.Builder tupleBuilder = ImmutableList.builder();
                while (i < fieldsPerRow) {
                    reducedValue = (RexNode)reducibleExps.get(row2 * fieldsPerRow + i);
                    if (reducedValue instanceof RexLiteral) {
                        tupleBuilder.add((RexLiteral)reducedValue);
                    } else if (RexUtil.isNullLiteral(reducedValue, true)) {
                        tupleBuilder.add(rexBuilder.constantNull());
                    } else {
                        return;
                    }
                    ++i;
                }
                valuesList = tupleBuilder.build();
            } else {
                valuesList = (ImmutableList)values.getTuples().get(row2);
            }
            tuplesBuilder.add(valuesList);
        }
        if (changeCount > 0) {
            RelDataType rowType = projectExprs != null ? project.getRowType() : values.getRowType();
            LogicalValues newRel = LogicalValues.create(values.getCluster(), rowType, (ImmutableList<ImmutableList<RexLiteral>>)tuplesBuilder.build());
            call.transformTo(newRel);
        } else {
            call.transformTo(values);
        }
        if (filter != null) {
            call.getPlanner().setImportance(filter, 0.0);
        }
    }

    private static class MyRexShuttle
    extends RexShuttle {
        private List<RexLiteral> literalList;

        private MyRexShuttle() {
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            return this.literalList.get(inputRef.getIndex());
        }
    }
}

