/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.NlsString;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;

public class SqlProperty
extends SqlCall {
    protected static final SqlOperator OPERATOR = new SqlSpecialOperator("Property", SqlKind.OTHER);
    private SqlIdentifier key;
    private SqlNode value;

    public SqlProperty(SqlIdentifier key, SqlNode value, SqlParserPos pos) {
        super(pos);
        this.key = Objects.requireNonNull(key, "Property key is missing");
        this.value = Objects.requireNonNull(value, "Property value is missing");
    }

    public SqlIdentifier getKey() {
        return this.key;
    }

    public SqlNode getValue() {
        return this.value;
    }

    public String getKeyString() {
        return this.key.toString();
    }

    public String getValueString() {
        return ((NlsString)SqlLiteral.value(this.value)).getValue();
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableList.of(this.key, this.value);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        this.key.unparse(writer, leftPrec, rightPrec);
        writer.keyword("=");
        this.value.unparse(writer, leftPrec, rightPrec);
    }
}

