/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.type.ExplicitOperandTypeInference;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.shaded.calcite.com.google.common.collect.ImmutableList;

public abstract class InferTypes {
    public static final SqlOperandTypeInference FIRST_KNOWN = (callBinding, returnType2, operandTypes) -> {
        RelDataType unknownType;
        RelDataType knownType = unknownType = callBinding.getValidator().getUnknownType();
        for (SqlNode operand : callBinding.operands()) {
            knownType = callBinding.getValidator().deriveType(callBinding.getScope(), operand);
            if (knownType.equals(unknownType)) continue;
            break;
        }
        for (int i = 0; i < operandTypes.length; ++i) {
            operandTypes[i] = knownType;
        }
    };
    public static final SqlOperandTypeInference RETURN_TYPE = (callBinding, returnType2, operandTypes) -> {
        for (int i = 0; i < operandTypes.length; ++i) {
            operandTypes[i] = returnType2.isStruct() ? returnType2.getFieldList().get(i).getType() : returnType2;
        }
    };
    public static final SqlOperandTypeInference BOOLEAN = (callBinding, returnType2, operandTypes) -> {
        RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
        for (int i = 0; i < operandTypes.length; ++i) {
            operandTypes[i] = typeFactory.createSqlType(SqlTypeName.BOOLEAN);
        }
    };
    public static final SqlOperandTypeInference VARCHAR_1024 = (callBinding, returnType2, operandTypes) -> {
        RelDataTypeFactory typeFactory = callBinding.getTypeFactory();
        for (int i = 0; i < operandTypes.length; ++i) {
            operandTypes[i] = typeFactory.createSqlType(SqlTypeName.VARCHAR, 1024);
        }
    };

    private InferTypes() {
    }

    public static SqlOperandTypeInference explicit(List<RelDataType> types) {
        return new ExplicitOperandTypeInference(ImmutableList.copyOf(types));
    }
}

