/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.validate.implicit;

import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.validate.SqlUserDefinedTableMacro;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.implicit.AbstractTypeCoercion;

public class TypeCoercionImpl
extends AbstractTypeCoercion {
    public TypeCoercionImpl(SqlValidator validator) {
        super(validator);
    }

    @Override
    public boolean widenColumnTypes(SqlValidatorScope scope, SqlNode query, int columnIndex, RelDataType targetType) {
        SqlKind kind = query.getKind();
        switch (kind) {
            case SELECT: {
                SqlSelect selectNode = (SqlSelect)query;
                SqlValidatorScope scope1 = this.validator.getSelectScope(selectNode);
                if (!this.coerceIthColumnTo(scope1, selectNode.getSelectList(), columnIndex, targetType)) {
                    return false;
                }
                this.updateInferredRowType(scope1, query, columnIndex, targetType);
                return true;
            }
            case VALUES: {
                for (SqlNode rowConstructor : ((SqlCall)query).getOperandList()) {
                    if (this.coerceIthOperandTo(scope, (SqlCall)rowConstructor, columnIndex, targetType)) continue;
                    return false;
                }
                this.updateInferredRowType(scope, query, columnIndex, targetType);
                return true;
            }
            case WITH: {
                SqlNode body = ((SqlWith)query).body;
                return this.widenColumnTypes(scope, body, columnIndex, targetType);
            }
            case UNION: 
            case INTERSECT: 
            case EXCEPT: {
                return this.widenColumnTypes(scope, (SqlNode)((SqlCall)query).operand(0), columnIndex, targetType) && this.widenColumnTypes(scope, (SqlNode)((SqlCall)query).operand(1), columnIndex, targetType);
            }
        }
        return false;
    }

    @Override
    public boolean binaryArithmeticPromote(SqlCallBinding binding) {
        SqlOperator operator = binding.getOperator();
        SqlKind kind = operator.getKind();
        boolean changed = false;
        if (binding.getOperandCount() == 2) {
            RelDataType commonType;
            RelDataType type1 = binding.getOperandType(0);
            RelDataType type2 = binding.getOperandType(1);
            if ((kind == SqlKind.PLUS || kind == SqlKind.MINUS) && (SqlTypeUtil.isInterval(type1) || SqlTypeUtil.isInterval(type2))) {
                return false;
            }
            if (kind.belongsTo(SqlKind.BINARY_ARITHMETIC)) {
                changed = this.binaryArithmeticWithStrings(binding);
                boolean bl = changed = this.divisionToFractional(binding, type1, type2) || changed;
            }
            if (kind.belongsTo(SqlKind.BINARY_EQUALITY)) {
                changed = this.dateTimeStringEquality(binding, type1, type2) || changed;
                boolean bl = changed = this.booleanEquality(binding, type1, type2) || changed;
            }
            if (kind.belongsTo(SqlKind.BINARY_COMPARISON) && null != (commonType = this.commonTypeForBinaryComparison(type1, type2))) {
                changed = this.coerceIthOperandTo(binding.getScope(), binding.getCall(), 0, commonType) || changed;
                boolean bl = changed = this.coerceIthOperandTo(binding.getScope(), binding.getCall(), 1, commonType) || changed;
            }
        }
        if (binding.getOperandCount() == 1) {
            RelDataType type = this.validator.deriveType(binding.getScope(), binding.operand(0));
            boolean isCharacterType = SqlTypeUtil.isCharacter(type);
            if (operator.getName().equalsIgnoreCase("ABS") && isCharacterType) {
                return this.coerceIthOperandTo(binding.getScope(), binding.getCall(), 0, this.factory.createSqlType(SqlTypeName.DOUBLE));
            }
            switch (kind) {
                case SUM: 
                case SUM0: 
                case AVG: 
                case STDDEV_POP: 
                case STDDEV_SAMP: 
                case MINUS_PREFIX: 
                case PLUS_PREFIX: 
                case VAR_POP: 
                case VAR_SAMP: {
                    if (!isCharacterType) break;
                    return this.coerceIthOperandTo(binding.getScope(), binding.getCall(), 0, this.factory.createSqlType(SqlTypeName.DOUBLE));
                }
            }
        }
        return changed;
    }

    protected boolean divisionToFractional(SqlCallBinding binding, RelDataType left, RelDataType right) {
        RelDataType targetType;
        if (binding.getOperator().getKind() != SqlKind.DIVIDE) {
            return false;
        }
        boolean changed = false;
        if (TypeCoercionImpl.isDoubleOrDecimal(left) || TypeCoercionImpl.isDoubleOrDecimal(right)) {
            return false;
        }
        if (TypeCoercionImpl.isNumericOrNull(left)) {
            targetType = this.factory.createTypeWithNullability(this.factory.createSqlType(SqlTypeName.DOUBLE), left.isNullable());
            boolean bl = changed = this.coerceIthOperandTo(binding.getScope(), binding.getCall(), 0, targetType) || changed;
        }
        if (TypeCoercionImpl.isNumericOrNull(right)) {
            targetType = this.factory.createTypeWithNullability(this.factory.createSqlType(SqlTypeName.DOUBLE), right.isNullable());
            changed = this.coerceIthOperandTo(binding.getScope(), binding.getCall(), 1, targetType) || changed;
        }
        return changed;
    }

    private static boolean isDoubleOrDecimal(RelDataType type) {
        return SqlTypeUtil.isDouble(type) || SqlTypeUtil.isDecimal(type);
    }

    private static boolean isNumericOrNull(RelDataType type) {
        return SqlTypeUtil.isNumeric(type) || SqlTypeUtil.isNull(type);
    }

    protected boolean binaryArithmeticWithStrings(SqlCallBinding binding) {
        boolean changed = false;
        for (int i = 0; i < binding.getOperandCount(); ++i) {
            RelDataType type = binding.getOperandType(i);
            if (!SqlTypeUtil.isCharacter(type)) continue;
            boolean tmp = this.coerceIthOperandTo(binding.getScope(), binding.getCall(), i, this.factory.createSqlType(SqlTypeName.DOUBLE));
            changed = tmp || changed;
        }
        return changed;
    }

    protected boolean dateTimeStringEquality(SqlCallBinding binding, RelDataType left, RelDataType right) {
        if (binding.getCall().getKind() == SqlKind.NOT_EQUALS) {
            if (SqlTypeUtil.isCharacter(left) && SqlTypeUtil.isDatetime(right)) {
                return this.coerceIthOperandTo(binding.getScope(), binding.getCall(), 0, right);
            }
            if (SqlTypeUtil.isCharacter(right) && SqlTypeUtil.isDatetime(left)) {
                return this.coerceIthOperandTo(binding.getScope(), binding.getCall(), 1, left);
            }
        }
        return false;
    }

    protected boolean booleanEquality(SqlCallBinding binding, RelDataType left, RelDataType right) {
        SqlNode lNode = binding.operand(0);
        SqlNode rNode = binding.operand(1);
        if (SqlTypeUtil.isNumeric(left) && SqlTypeUtil.isBoolean(right)) {
            if (lNode.getKind() == SqlKind.LITERAL) {
                BigDecimal val = ((SqlLiteral)lNode).bigDecimalValue();
                if (val.compareTo(BigDecimal.ONE) == 0) {
                    SqlLiteral lNode1 = SqlLiteral.createBoolean(true, SqlParserPos.ZERO);
                    binding.getCall().setOperand(0, lNode1);
                    return true;
                }
                SqlLiteral lNode1 = SqlLiteral.createBoolean(false, SqlParserPos.ZERO);
                binding.getCall().setOperand(0, lNode1);
                return true;
            }
            return this.coerceIthOperandTo(binding.getScope(), binding.getCall(), 1, left);
        }
        if (SqlTypeUtil.isNumeric(right) && SqlTypeUtil.isBoolean(left)) {
            if (rNode.getKind() == SqlKind.LITERAL) {
                BigDecimal val = ((SqlLiteral)rNode).bigDecimalValue();
                if (val.compareTo(new BigDecimal(1)) == 0) {
                    SqlLiteral rNode1 = SqlLiteral.createBoolean(true, SqlParserPos.ZERO);
                    binding.getCall().setOperand(1, rNode1);
                    return true;
                }
                SqlLiteral rNode1 = SqlLiteral.createBoolean(false, SqlParserPos.ZERO);
                binding.getCall().setOperand(1, rNode1);
                return true;
            }
            return this.coerceIthOperandTo(binding.getScope(), binding.getCall(), 0, right);
        }
        return false;
    }

    @Override
    public boolean caseWhenCoercion(SqlCallBinding callBinding) {
        SqlCase caseCall = (SqlCase)callBinding.getCall();
        SqlNodeList thenList = caseCall.getThenOperands();
        ArrayList<RelDataType> argTypes = new ArrayList<RelDataType>();
        for (SqlNode node : thenList) {
            argTypes.add(this.validator.deriveType(callBinding.getScope(), node));
        }
        SqlNode elseOp = caseCall.getElseOperand();
        RelDataType elseOpType = this.validator.deriveType(callBinding.getScope(), caseCall.getElseOperand());
        argTypes.add(elseOpType);
        RelDataType widerType = this.getWiderTypeFor(argTypes, true);
        if (null != widerType) {
            boolean changed = false;
            for (int i = 0; i < thenList.size(); ++i) {
                changed = this.coerceIthColumnTo(callBinding.getScope(), thenList, i, widerType) || changed;
            }
            if (this.needToCast(callBinding.getScope(), elseOp, widerType)) {
                changed = this.coerceIthOperandTo(callBinding.getScope(), caseCall, 3, widerType) || changed;
            }
            return changed;
        }
        return false;
    }

    @Override
    public boolean inOperationConversion(SqlCallBinding binding) {
        SqlOperator operator = binding.getOperator();
        if (operator.getKind() == SqlKind.IN) {
            int i;
            assert (binding.getOperandCount() == 2);
            RelDataType type1 = binding.getOperandType(0);
            RelDataType type2 = binding.getOperandType(1);
            SqlNode node1 = binding.operand(0);
            SqlNode node2 = binding.operand(1);
            SqlValidatorScope scope = binding.getScope();
            if (type1.isStruct() && type2.isStruct() && type1.getFieldCount() != type2.getFieldCount()) {
                return false;
            }
            int colCount = type1.isStruct() ? type1.getFieldCount() : 1;
            final RelDataType[] argTypes = new RelDataType[]{type1, type2};
            boolean changed = false;
            ArrayList<RelDataType> widenTypes = new ArrayList<RelDataType>();
            for (i = 0; i < colCount; ++i) {
                final int i2 = i;
                AbstractList<RelDataType> columnIthTypes = new AbstractList<RelDataType>(){

                    @Override
                    public RelDataType get(int index) {
                        return argTypes[index].isStruct() ? argTypes[index].getFieldList().get(i2).getType() : argTypes[index];
                    }

                    @Override
                    public int size() {
                        return argTypes.length;
                    }
                };
                RelDataType widenType = this.commonTypeForBinaryComparison((RelDataType)columnIthTypes.get(0), (RelDataType)columnIthTypes.get(1));
                if (widenType == null) {
                    widenType = this.getTightestCommonType((RelDataType)columnIthTypes.get(0), (RelDataType)columnIthTypes.get(1));
                }
                if (widenType == null) {
                    return false;
                }
                widenTypes.add(widenType);
            }
            assert (widenTypes.size() == colCount);
            for (i = 0; i < widenTypes.size(); ++i) {
                RelDataType desired = (RelDataType)widenTypes.get(i);
                if (node1.getKind() == SqlKind.ROW) {
                    assert (node1 instanceof SqlCall);
                    if (this.coerceIthOperandTo(scope, (SqlCall)node1, i, desired)) {
                        this.updateInferredRowType(scope, node1, i, (RelDataType)widenTypes.get(i));
                        changed = true;
                    }
                } else {
                    boolean bl = changed = this.coerceIthOperandTo(scope, binding.getCall(), 0, desired) || changed;
                }
                if (node2 instanceof SqlNodeList) {
                    SqlNodeList node3 = (SqlNodeList)node2;
                    boolean listChanged = false;
                    if (type2.isStruct()) {
                        for (SqlNode node : (SqlNodeList)node2) {
                            assert (node instanceof SqlCall);
                            listChanged = this.coerceIthOperandTo(scope, (SqlCall)node, i, desired) || listChanged;
                        }
                        if (listChanged) {
                            this.updateInferredRowType(scope, node2, i, desired);
                        }
                    } else {
                        for (int j2 = 0; j2 < ((SqlNodeList)node2).size(); ++j2) {
                            listChanged = this.coerceIthColumnTo(scope, node3, j2, desired) || listChanged;
                        }
                        if (listChanged) {
                            this.updateInferredTypesFor(node2, desired);
                        }
                    }
                    changed = listChanged || changed;
                    continue;
                }
                SqlValidatorScope scope1 = node2 instanceof SqlSelect ? this.validator.getSelectScope((SqlSelect)node2) : scope;
                changed = this.widenColumnTypes(scope1, node2, i, desired) || changed;
            }
            return changed;
        }
        return false;
    }

    @Override
    public boolean implicitTypeCast(SqlCallBinding binding, List<RelDataType> operandTypes, List<SqlTypeFamily> expectedFamilies) {
        assert (binding.getOperandCount() == operandTypes.size());
        if (!this.canImplicitTypeCast(operandTypes, expectedFamilies)) {
            return false;
        }
        boolean changed = false;
        for (int i = 0; i < operandTypes.size(); ++i) {
            RelDataType implicitType = this.implicitCast(operandTypes.get(i), expectedFamilies.get(i));
            changed = null != implicitType && operandTypes.get(i) != implicitType && this.coerceIthOperandTo(binding.getScope(), binding.getCall(), i, implicitType) || changed;
        }
        return changed;
    }

    @Override
    public boolean coerceFunctionParams(SqlValidatorScope scope, SqlCall call, SqlFunction function) {
        List<RelDataType> paramTypes = function.getParamTypes();
        assert (paramTypes != null);
        boolean changed = false;
        if (function instanceof SqlUserDefinedTableMacro) {
            return false;
        }
        for (int i = 0; i < call.operandCount(); ++i) {
            Object operand = call.operand(i);
            if (((SqlNode)operand).getKind() == SqlKind.ARGUMENT_ASSIGNMENT) {
                List<SqlNode> operandList = ((SqlCall)operand).getOperandList();
                String name = ((SqlIdentifier)operandList.get(1)).getSimple();
                int formalIndex = function.getParamNames().indexOf(name);
                if (formalIndex < 0) {
                    return false;
                }
                changed = this.coerceIthOperandTo(scope, (SqlCall)operand, 0, paramTypes.get(formalIndex)) || changed;
                continue;
            }
            changed = this.coerceIthOperandTo(scope, call, i, paramTypes.get(i)) || changed;
        }
        return changed;
    }
}

