/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.accumulators;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;

@PublicEvolving
public class SerializedListAccumulator<T>
implements Accumulator<T, ArrayList<byte[]>> {
    private static final long serialVersionUID = 1L;
    private ArrayList<byte[]> localValue = new ArrayList();

    @Override
    public void add(T value) {
        throw new UnsupportedOperationException();
    }

    public void add(T value, TypeSerializer<T> serializer) throws IOException {
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper(outStream);
            serializer.serialize(value, out);
            this.localValue.add(outStream.toByteArray());
        }
        catch (IOException e2) {
            throw new IOException("Failed to serialize value '" + value + '\'', e2);
        }
    }

    @Override
    public ArrayList<byte[]> getLocalValue() {
        return this.localValue;
    }

    @Override
    public void resetLocal() {
        this.localValue.clear();
    }

    @Override
    public void merge(Accumulator<T, ArrayList<byte[]>> other) {
        this.localValue.addAll((Collection<byte[]>)other.getLocalValue());
    }

    public SerializedListAccumulator<T> clone() {
        SerializedListAccumulator<T> newInstance = new SerializedListAccumulator<T>();
        newInstance.localValue = new ArrayList<byte[]>(this.localValue);
        return newInstance;
    }

    public static <T> List<T> deserializeList(ArrayList<byte[]> data, TypeSerializer<T> serializer) throws IOException, ClassNotFoundException {
        ArrayList<T> result = new ArrayList<T>(data.size());
        for (byte[] bytes : data) {
            ByteArrayInputStream inStream = new ByteArrayInputStream(bytes);
            DataInputViewStreamWrapper in = new DataInputViewStreamWrapper(inStream);
            T val = serializer.deserialize(in);
            result.add(val);
        }
        return result;
    }

    public String toString() {
        return "SerializedListAccumulator: " + this.localValue.size() + " elements";
    }
}

