/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.functions;

import java.util.Map;
import org.apache.flink.api.common.functions.Merger;
import org.apache.flink.util.Preconditions;

public final class MapMerger<K, V>
implements Merger<Map<K, V>> {
    private static final long serialVersionUID = 1L;
    private final Merger<V> valueMerger;

    public MapMerger(Merger<V> valueMerger) {
        Preconditions.checkNotNull(valueMerger);
        this.valueMerger = valueMerger;
    }

    public Merger<V> getValueMerger() {
        return this.valueMerger;
    }

    @Override
    public Map<K, V> merge(Map<K, V> map1, Map<K, V> map2) {
        Preconditions.checkNotNull(map1);
        Preconditions.checkNotNull(map2);
        for (Map.Entry<K, V> entry : map2.entrySet()) {
            V oldValue = map1.get(entry.getKey());
            if (oldValue == null) {
                map1.put(entry.getKey(), entry.getValue());
                continue;
            }
            V newValue = this.valueMerger.merge(oldValue, entry.getValue());
            map1.put(entry.getKey(), newValue);
        }
        return map1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapMerger mapMerger = (MapMerger)o;
        return this.valueMerger.equals(mapMerger.valueMerger);
    }

    public int hashCode() {
        return this.valueMerger.hashCode();
    }

    public String toString() {
        return "MapMerger{valueMerger=" + this.valueMerger + "}";
    }
}

