/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.functions;

import java.util.Arrays;
import org.apache.flink.api.common.functions.Merger;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

public class RowMerger
implements Merger<Row> {
    private static final long serialVersionUID = 1L;
    private final Merger<?>[] fieldMergers;

    public RowMerger(Merger<?>[] fieldMergers) {
        Preconditions.checkNotNull(fieldMergers);
        for (Merger<?> fieldMerger : fieldMergers) {
            Preconditions.checkNotNull(fieldMerger);
        }
        this.fieldMergers = fieldMergers;
    }

    @Override
    public Row merge(Row row1, Row row2) {
        Preconditions.checkNotNull(row1);
        Preconditions.checkArgument(row1.getArity() == this.fieldMergers.length);
        Preconditions.checkNotNull(row2);
        Preconditions.checkArgument(row2.getArity() == this.fieldMergers.length);
        Row mergedRow = new Row(this.fieldMergers.length);
        for (int i = 0; i < this.fieldMergers.length; ++i) {
            Object fieldValue1 = row1.getField(i);
            Object fieldValue2 = row2.getField(i);
            Merger<?> fieldMerger = this.fieldMergers[i];
            Object mergedFieldValue = fieldMerger.merge(fieldValue1, fieldValue2);
            mergedRow.setField(i, mergedFieldValue);
        }
        return mergedRow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RowMerger rowMerger = (RowMerger)o;
        return Arrays.equals(this.fieldMergers, rowMerger.fieldMergers);
    }

    public int hashCode() {
        return Arrays.hashCode(this.fieldMergers);
    }

    public String toString() {
        return "RowMerger{fieldMergers=" + Arrays.toString(this.fieldMergers) + "}";
    }
}

