/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.io.blockcompression;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.flink.api.common.io.blockcompression.AbstractBlockDecompressor;
import org.apache.flink.api.common.io.blockcompression.DataCorruptionException;
import org.apache.flink.api.common.io.blockcompression.InsufficientBufferException;
import org.apache.flink.api.common.io.blockcompression.ReusableByteArrayInputStream;

public class GzipBlockDecompressor
extends AbstractBlockDecompressor {
    private ReusableByteArrayInputStream srcStream;

    @Override
    public int decompress(byte[] src, int srcOff, int srcLen, byte[] dst, int dstOff) throws InsufficientBufferException, DataCorruptionException {
        try {
            if (this.srcStream == null) {
                this.srcStream = new ReusableByteArrayInputStream(src, srcOff, srcLen);
            } else {
                this.srcStream.reuse(src, srcOff, srcLen);
            }
            GzipCompressorInputStream decompressStream = new GzipCompressorInputStream((InputStream)this.srcStream);
            int decompressedLen = decompressStream.read(dst, dstOff, dst.length - dstOff);
            this.srcStream.close();
            decompressStream.close();
            if (decompressedLen < 0) {
                throw new DataCorruptionException("Fail to decompress, decompressedLen: " + decompressedLen);
            }
            return decompressedLen;
        }
        catch (IOException e2) {
            throw new DataCorruptionException(e2);
        }
    }
}

