/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.operators;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.operators.ResourceConstraints;
import org.apache.flink.util.Preconditions;

public class StrictlyMatchingResourceConstraints
implements ResourceConstraints {
    private final Map<String, String> constraints = new HashMap<String, String>();

    @Override
    public Map<String, String> getConstraints() {
        return this.constraints;
    }

    @Override
    public boolean isCompatibleWith(ResourceConstraints other) {
        return this.equals(other);
    }

    @Override
    public ResourceConstraints merge(ResourceConstraints other) {
        return this;
    }

    @Override
    public ResourceConstraints addConstraint(String key, String val) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(val);
        this.constraints.put(key, val);
        return this;
    }

    private ResourceConstraints addConstraints(Map<String, String> toAdd) {
        this.constraints.putAll(toAdd);
        return this;
    }

    @Override
    public ResourceConstraints clone() {
        StrictlyMatchingResourceConstraints constraints = new StrictlyMatchingResourceConstraints();
        constraints.addConstraints(this.constraints);
        return constraints;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResourceConstraints)) {
            return false;
        }
        return this.constraints.equals(((ResourceConstraints)other).getConstraints());
    }

    public int hashCode() {
        return this.constraints.hashCode();
    }

    public String toString() {
        StringBuilder constraintsStr = new StringBuilder(this.constraints.size() * 30);
        constraintsStr.append("[");
        for (Map.Entry<String, String> constraint : this.constraints.entrySet()) {
            constraintsStr.append(constraint.getKey()).append('=').append(constraint.getValue()).append(", ");
        }
        if (constraintsStr.length() >= 3) {
            constraintsStr.replace(constraintsStr.length() - 2, constraintsStr.length(), "]");
        } else {
            constraintsStr.append("]");
        }
        return constraintsStr.toString();
    }
}

