/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.time;

import java.time.Duration;
import org.apache.flink.annotation.Internal;

@Internal
public class Deadline {
    private final long timeNanos;

    private Deadline(long deadline) {
        this.timeNanos = deadline;
    }

    public Deadline plus(Duration other) {
        return new Deadline(Math.addExact(this.timeNanos, other.toNanos()));
    }

    public Duration timeLeft() {
        return Duration.ofNanos(Math.subtractExact(this.timeNanos, System.nanoTime()));
    }

    public boolean hasTimeLeft() {
        return !this.isOverdue();
    }

    public boolean isOverdue() {
        return this.timeNanos < System.nanoTime();
    }

    public static Deadline now() {
        return new Deadline(System.nanoTime());
    }

    public static Deadline fromNow(Duration duration) {
        return new Deadline(Math.addExact(System.nanoTime(), duration.toNanos()));
    }
}

