/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeinfo;

import java.lang.reflect.Constructor;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.DateComparator;
import org.apache.flink.api.common.typeutils.base.SqlDateSerializer;
import org.apache.flink.api.common.typeutils.base.SqlTimeSerializer;
import org.apache.flink.api.common.typeutils.base.SqlTimestampComparator;
import org.apache.flink.api.common.typeutils.base.SqlTimestampSerializer;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class SqlTimeTypeInfo<T>
extends TypeInformation<T>
implements AtomicType<T> {
    private static final long serialVersionUID = -132955295409131880L;
    public static final SqlTimeTypeInfo<Date> DATE = new SqlTimeTypeInfo<Date>(Date.class, SqlDateSerializer.INSTANCE, DateComparator.class);
    public static final SqlTimeTypeInfo<Time> TIME = new SqlTimeTypeInfo<Time>(Time.class, SqlTimeSerializer.INSTANCE, DateComparator.class);
    public static final SqlTimeTypeInfo<Timestamp> TIMESTAMP = new SqlTimeTypeInfo<Timestamp>(Timestamp.class, SqlTimestampSerializer.INSTANCE, SqlTimestampComparator.class);
    private final Class<T> clazz;
    private final TypeSerializer<T> serializer;
    private final Class<? extends TypeComparator<T>> comparatorClass;

    protected SqlTimeTypeInfo(Class<T> clazz, TypeSerializer<T> serializer, Class<? extends TypeComparator<T>> comparatorClass) {
        this.clazz = Preconditions.checkNotNull(clazz);
        this.serializer = Preconditions.checkNotNull(serializer);
        this.comparatorClass = Preconditions.checkNotNull(comparatorClass);
    }

    @Override
    public boolean isBasicType() {
        return false;
    }

    @Override
    public boolean isTupleType() {
        return false;
    }

    @Override
    public int getArity() {
        return 1;
    }

    @Override
    public int getTotalFields() {
        return 1;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.clazz;
    }

    @Override
    public boolean isKeyType() {
        return true;
    }

    @Override
    public TypeSerializer<T> createSerializer(ExecutionConfig executionConfig) {
        return this.serializer;
    }

    @Override
    public TypeComparator<T> createComparator(boolean sortOrderAscending, ExecutionConfig executionConfig) {
        return SqlTimeTypeInfo.instantiateComparator(this.comparatorClass, sortOrderAscending);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clazz, this.serializer, this.comparatorClass);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj instanceof SqlTimeTypeInfo;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SqlTimeTypeInfo) {
            SqlTimeTypeInfo other = (SqlTimeTypeInfo)obj;
            return other.canEqual(this) && this.clazz == other.clazz && this.serializer.equals(other.serializer) && this.comparatorClass == other.comparatorClass;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.clazz.getSimpleName();
    }

    private static <X> TypeComparator<X> instantiateComparator(Class<? extends TypeComparator<X>> comparatorClass, boolean ascendingOrder) {
        try {
            Constructor<TypeComparator<X>> constructor = comparatorClass.getConstructor(Boolean.TYPE);
            return constructor.newInstance(ascendingOrder);
        }
        catch (Exception e2) {
            throw new RuntimeException("Could not initialize comparator " + comparatorClass.getName(), e2);
        }
    }

    public static <X> SqlTimeTypeInfo<X> getInfoFor(Class<X> type) {
        Preconditions.checkNotNull(type);
        if (type == Date.class) {
            return DATE;
        }
        if (type == Time.class) {
            return TIME;
        }
        if (type == Timestamp.class) {
            return TIMESTAMP;
        }
        return null;
    }
}

