/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.base.BasicTypeComparator;
import org.apache.flink.api.common.typeutils.base.ComparatorUtil;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.MemorySegment;

@Internal
public final class CharComparator
extends BasicTypeComparator<Character> {
    private static final long serialVersionUID = 1L;

    public CharComparator(boolean ascending) {
        super(ascending);
    }

    @Override
    public int compareSerialized(DataInputView firstSource, DataInputView secondSource) throws IOException {
        char c2;
        char c1 = firstSource.readChar();
        int comp = c1 < (c2 = secondSource.readChar()) ? -1 : (c1 == c2 ? 0 : 1);
        return this.ascendingComparison ? comp : -comp;
    }

    @Override
    public boolean supportsNormalizedKey() {
        return true;
    }

    @Override
    public int getNormalizeKeyLen() {
        return 2;
    }

    @Override
    public boolean isNormalizedKeyPrefixOnly(int keyBytes) {
        return keyBytes < 2;
    }

    @Override
    public void putNormalizedKey(Character value, MemorySegment target, int offset, int numBytes) {
        ComparatorUtil.putCharNormalizedKey(value.charValue(), target, offset, numBytes);
    }

    public CharComparator duplicate() {
        return new CharComparator(this.ascendingComparison);
    }
}

