/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.typeutils.base;

import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.flink.api.common.functions.Comparator;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.CompatibilityUtil;
import org.apache.flink.api.common.typeutils.TypeDeserializerAdapter;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.UnloadableDummyTypeSerializer;
import org.apache.flink.api.common.typeutils.base.AbstractMapSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializerConfigSnapshot;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.util.Preconditions;

public final class SortedMapSerializer<K, V>
extends AbstractMapSerializer<K, V, SortedMap<K, V>> {
    private static final long serialVersionUID = 1L;
    private final Comparator<K> comparator;

    public SortedMapSerializer(Comparator<K> comparator, TypeSerializer<K> keySerializer, TypeSerializer<V> valueSerializer) {
        super(keySerializer, valueSerializer);
        Preconditions.checkNotNull(comparator, "The comparator cannot be null.");
        this.comparator = comparator;
    }

    public Comparator<K> getComparator() {
        return this.comparator;
    }

    @Override
    public TypeSerializer<SortedMap<K, V>> duplicate() {
        TypeSerializer keySerializer = this.getKeySerializer().duplicate();
        TypeSerializer valueSerializer = this.getValueSerializer().duplicate();
        return new SortedMapSerializer(this.comparator, keySerializer, valueSerializer);
    }

    @Override
    public SortedMap<K, V> createInstance() {
        return new TreeMap(this.comparator);
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        SortedMapSerializer that = (SortedMapSerializer)o;
        return this.comparator.equals(that.comparator);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = result * 31 + this.comparator.hashCode();
        return result;
    }

    public String toString() {
        return "SortedMapSerializer{comparator = " + this.comparator + ", keySerializer = " + this.keySerializer + ", valueSerializer = " + this.valueSerializer + "}";
    }

    @Override
    public TypeSerializerConfigSnapshot snapshotConfiguration() {
        return new MapSerializerConfigSnapshot(this.keySerializer, this.valueSerializer);
    }

    @Override
    public CompatibilityResult<SortedMap<K, V>> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        if (configSnapshot instanceof MapSerializerConfigSnapshot) {
            List<Tuple2<TypeSerializer<?>, TypeSerializerConfigSnapshot>> previousKvSerializersAndConfigs = ((MapSerializerConfigSnapshot)configSnapshot).getNestedSerializersAndConfigs();
            CompatibilityResult keyCompatResult = CompatibilityUtil.resolveCompatibilityResult((TypeSerializer)previousKvSerializersAndConfigs.get((int)0).f0, UnloadableDummyTypeSerializer.class, (TypeSerializerConfigSnapshot)previousKvSerializersAndConfigs.get((int)0).f1, this.keySerializer);
            CompatibilityResult valueCompatResult = CompatibilityUtil.resolveCompatibilityResult((TypeSerializer)previousKvSerializersAndConfigs.get((int)1).f0, UnloadableDummyTypeSerializer.class, (TypeSerializerConfigSnapshot)previousKvSerializersAndConfigs.get((int)1).f1, this.valueSerializer);
            if (!keyCompatResult.isRequiresMigration() && !valueCompatResult.isRequiresMigration()) {
                return CompatibilityResult.compatible();
            }
            if (keyCompatResult.getConvertDeserializer() != null && valueCompatResult.getConvertDeserializer() != null) {
                return CompatibilityResult.requiresMigration(new SortedMapSerializer(this.comparator, new TypeDeserializerAdapter(keyCompatResult.getConvertDeserializer()), new TypeDeserializerAdapter(valueCompatResult.getConvertDeserializer())));
            }
        }
        return CompatibilityResult.requiresMigration();
    }
}

