/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils;

import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.util.Preconditions;

abstract class AbstractMapTypeInfo<K, V, M extends Map<K, V>>
extends TypeInformation<M> {
    private static final long serialVersionUID = 1L;
    final TypeInformation<K> keyTypeInfo;
    final TypeInformation<V> valueTypeInfo;

    AbstractMapTypeInfo(TypeInformation<K> keyTypeInfo, TypeInformation<V> valueTypeInfo) {
        Preconditions.checkNotNull(keyTypeInfo, "The type information for the keys cannot be null.");
        Preconditions.checkNotNull(valueTypeInfo, "The type information for the values cannot be null.");
        this.keyTypeInfo = keyTypeInfo;
        this.valueTypeInfo = valueTypeInfo;
    }

    AbstractMapTypeInfo(Class<K> keyClass, Class<V> valueClass) {
        Preconditions.checkNotNull(keyClass, "The key class cannot be null.");
        Preconditions.checkNotNull(valueClass, "The value class cannot be null.");
        this.keyTypeInfo = TypeInformation.of(keyClass);
        this.valueTypeInfo = TypeInformation.of(valueClass);
    }

    public TypeInformation<K> getKeyTypeInfo() {
        return this.keyTypeInfo;
    }

    public TypeInformation<V> getValueTypeInfo() {
        return this.valueTypeInfo;
    }

    @Override
    public boolean isBasicType() {
        return false;
    }

    @Override
    public boolean isTupleType() {
        return false;
    }

    @Override
    public int getArity() {
        return 0;
    }

    @Override
    public int getTotalFields() {
        return 2;
    }

    @Override
    public boolean isKeyType() {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractMapTypeInfo that = (AbstractMapTypeInfo)o;
        return this.keyTypeInfo.equals(that.keyTypeInfo) && this.valueTypeInfo.equals(that.valueTypeInfo);
    }

    @Override
    public int hashCode() {
        int result = this.keyTypeInfo.hashCode();
        result = 31 * result + this.valueTypeInfo.hashCode();
        return result;
    }
}

