/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.memory.DataInputView;

@Internal
public class DataInputViewStream
extends InputStream {
    protected DataInputView inputView;

    public DataInputViewStream(DataInputView inputView) {
        this.inputView = inputView;
    }

    public DataInputView getInputView() {
        return this.inputView;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.inputView.readUnsignedByte();
        }
        catch (EOFException ex) {
            return -1;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        long counter;
        int skippedBytes;
        for (counter = n; counter > Integer.MAX_VALUE; counter -= (long)skippedBytes) {
            skippedBytes = this.inputView.skipBytes(Integer.MAX_VALUE);
            if (skippedBytes != 0) continue;
            return n - counter;
        }
        return n - counter - (long)this.inputView.skipBytes((int)counter);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.inputView.read(b, off, len);
    }
}

