/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.Serializable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerFactory;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.InstantiationUtil;

@Internal
public final class RuntimeSerializerFactory<T>
implements TypeSerializerFactory<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String CONFIG_KEY_SER = "SER_DATA";
    private static final String CONFIG_KEY_CLASS = "CLASS_DATA";
    private TypeSerializer<T> serializer;
    private boolean firstSerializer = true;
    private Class<T> clazz;

    public RuntimeSerializerFactory() {
    }

    public RuntimeSerializerFactory(TypeSerializer<T> serializer, Class<T> clazz) {
        if (serializer == null || clazz == null) {
            throw new NullPointerException();
        }
        this.clazz = clazz;
        this.serializer = serializer;
    }

    @Override
    public void writeParametersToConfig(Configuration config) {
        try {
            InstantiationUtil.writeObjectToConfig(this.clazz, config, CONFIG_KEY_CLASS);
            InstantiationUtil.writeObjectToConfig(this.serializer, config, CONFIG_KEY_SER);
        }
        catch (Exception e2) {
            throw new RuntimeException("Could not serialize serializer into the configuration.", e2);
        }
    }

    @Override
    public void readParametersFromConfig(Configuration config, ClassLoader cl) throws ClassNotFoundException {
        if (config == null || cl == null) {
            throw new NullPointerException();
        }
        try {
            this.clazz = (Class)InstantiationUtil.readObjectFromConfig(config, CONFIG_KEY_CLASS, cl);
            this.serializer = (TypeSerializer)InstantiationUtil.readObjectFromConfig(config, CONFIG_KEY_SER, cl);
            this.firstSerializer = true;
        }
        catch (ClassNotFoundException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new RuntimeException("Could not load deserializer from the configuration.", e3);
        }
    }

    @Override
    public TypeSerializer<T> getSerializer() {
        if (this.serializer != null) {
            if (this.firstSerializer) {
                this.firstSerializer = false;
                return this.serializer;
            }
            return this.serializer.duplicate();
        }
        throw new RuntimeException("SerializerFactory has not been initialized from configuration.");
    }

    @Override
    public Class<T> getDataType() {
        return this.clazz;
    }

    public int hashCode() {
        return this.clazz.hashCode() ^ this.serializer.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RuntimeSerializerFactory) {
            RuntimeSerializerFactory other = (RuntimeSerializerFactory)obj;
            return this.clazz == other.clazz && this.serializer.equals(other.serializer);
        }
        return false;
    }
}

