/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.IOException;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.contrib.streaming.state.RocksDBKeySerializationUtils;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackend;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.queryablestate.client.state.serialization.KvStateSerializer;
import org.apache.flink.runtime.state.KeyGroupRangeAssignment;
import org.apache.flink.runtime.state.internal.InternalKvState;
import org.apache.flink.util.Preconditions;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;
import org.rocksdb.WriteOptions;

@Deprecated
public abstract class AbstractRocksDBState<K, N, V, S extends State>
implements InternalKvState<K, N, V>,
State {
    final TypeSerializer<N> namespaceSerializer;
    final TypeSerializer<V> valueSerializer;
    private N currentNamespace;
    protected RocksDBKeyedStateBackend<K> backend;
    protected ColumnFamilyHandle columnFamily;
    protected final V defaultValue;
    protected final WriteOptions writeOptions;
    protected final ByteArrayOutputStreamWithPos keySerializationStream;
    protected final DataOutputView keySerializationDataOutputView;
    private final boolean ambiguousKeyPossible;

    protected AbstractRocksDBState(ColumnFamilyHandle columnFamily, TypeSerializer<N> namespaceSerializer, TypeSerializer<V> valueSerializer, V defaultValue, RocksDBKeyedStateBackend<K> backend) {
        this.namespaceSerializer = namespaceSerializer;
        this.backend = backend;
        this.columnFamily = columnFamily;
        this.writeOptions = backend.getWriteOptions();
        this.valueSerializer = Preconditions.checkNotNull(valueSerializer, "State value serializer");
        this.defaultValue = defaultValue;
        this.keySerializationStream = new ByteArrayOutputStreamWithPos(128);
        this.keySerializationDataOutputView = new DataOutputViewStreamWrapper(this.keySerializationStream);
        this.ambiguousKeyPossible = RocksDBKeySerializationUtils.isAmbiguousKeyPossible(backend.getKeySerializer(), namespaceSerializer);
    }

    @Override
    public void clear() {
        try {
            this.writeCurrentKeyWithGroupAndNamespace();
            byte[] key = this.keySerializationStream.toByteArray();
            this.backend.db.delete(this.columnFamily, this.writeOptions, key);
        }
        catch (IOException | RocksDBException e2) {
            throw new RuntimeException("Error while removing entry from RocksDB", e2);
        }
    }

    public void setCurrentNamespace(N namespace) {
        this.currentNamespace = Preconditions.checkNotNull(namespace, "Namespace");
    }

    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<N> safeNamespaceSerializer, TypeSerializer<V> safeValueSerializer) throws Exception {
        Preconditions.checkNotNull(serializedKeyAndNamespace);
        Preconditions.checkNotNull(safeKeySerializer);
        Preconditions.checkNotNull(safeNamespaceSerializer);
        Preconditions.checkNotNull(safeValueSerializer);
        Tuple2 keyAndNamespace = KvStateSerializer.deserializeKeyAndNamespace((byte[])serializedKeyAndNamespace, safeKeySerializer, safeNamespaceSerializer);
        int keyGroup = KeyGroupRangeAssignment.assignToKeyGroup(keyAndNamespace.f0, (int)this.backend.getNumberOfKeyGroups());
        ByteArrayOutputStreamWithPos tmpKeySerializationStream = new ByteArrayOutputStreamWithPos(128);
        DataOutputViewStreamWrapper tmpKeySerializationDateDataOutputView = new DataOutputViewStreamWrapper(tmpKeySerializationStream);
        this.writeKeyWithGroupAndNamespace(keyGroup, keyAndNamespace.f0, safeKeySerializer, keyAndNamespace.f1, safeNamespaceSerializer, tmpKeySerializationStream, tmpKeySerializationDateDataOutputView);
        return this.backend.db.get(this.columnFamily, tmpKeySerializationStream.toByteArray());
    }

    protected void writeCurrentKeyWithGroupAndNamespace() throws IOException {
        this.writeKeyWithGroupAndNamespace(this.backend.getCurrentKeyGroupIndex(), this.backend.getCurrentKey(), this.currentNamespace, this.keySerializationStream, this.keySerializationDataOutputView);
    }

    protected void writeKeyWithGroupAndNamespace(int keyGroup, K key, N namespace, ByteArrayOutputStreamWithPos keySerializationStream, DataOutputView keySerializationDataOutputView) throws IOException {
        this.writeKeyWithGroupAndNamespace(keyGroup, key, this.backend.getKeySerializer(), namespace, this.namespaceSerializer, keySerializationStream, keySerializationDataOutputView);
    }

    protected void writeKeyWithGroupAndNamespace(int keyGroup, K key, TypeSerializer<K> keySerializer, N namespace, TypeSerializer<N> namespaceSerializer, ByteArrayOutputStreamWithPos keySerializationStream, DataOutputView keySerializationDataOutputView) throws IOException {
        Preconditions.checkNotNull(key, "No key set. This method should not be called outside of a keyed context.");
        Preconditions.checkNotNull(keySerializer);
        Preconditions.checkNotNull(namespaceSerializer);
        keySerializationStream.reset();
        RocksDBKeySerializationUtils.writeKeyGroup(keyGroup, this.backend.getKeyGroupPrefixBytes(), keySerializationDataOutputView);
        RocksDBKeySerializationUtils.writeKey(key, keySerializer, keySerializationStream, keySerializationDataOutputView, this.ambiguousKeyPossible);
        RocksDBKeySerializationUtils.writeNameSpace(namespace, namespaceSerializer, keySerializationStream, keySerializationDataOutputView, this.ambiguousKeyPossible);
    }

    protected V getDefaultValue() {
        if (this.defaultValue != null) {
            return this.valueSerializer.copy(this.defaultValue);
        }
        return null;
    }
}

