/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.flink.contrib.streaming.state.RocksDBPair;
import org.apache.flink.contrib.streaming.state.RocksDBStorageInstance;
import org.apache.flink.util.Preconditions;
import org.rocksdb.RocksIterator;

abstract class AbstractRocksDbStorageIterator<T>
implements Iterator<T> {
    private static final int CACHE_SIZE_LIMIT = 128;
    private final List<RocksDBPair> cachePairs;
    private RocksDBStorageInstance dbStorageInstance;
    private RocksDBPair currentPair;
    private boolean expired;
    private int cacheIndex;

    AbstractRocksDbStorageIterator(RocksDBStorageInstance dbStorageInstance) {
        this.dbStorageInstance = dbStorageInstance;
        this.cachePairs = new ArrayList<RocksDBPair>();
        this.expired = false;
        this.cacheIndex = 0;
    }

    abstract byte[] getStartDBKey();

    abstract boolean isEndDBKey(byte[] var1);

    @Override
    public boolean hasNext() {
        this.loadCachePairs();
        return this.cacheIndex < this.cachePairs.size();
    }

    @Override
    public void remove() {
        if (this.currentPair == null || this.currentPair.isDeleted()) {
            throw new IllegalStateException("The remove operation must be called after a valid next operation.");
        }
        this.currentPair.remove();
    }

    final RocksDBPair getNextPair() {
        this.loadCachePairs();
        if (this.cacheIndex == this.cachePairs.size()) {
            Preconditions.checkState(this.expired);
            throw new NoSuchElementException();
        }
        this.currentPair = this.cachePairs.get(this.cacheIndex);
        ++this.cacheIndex;
        return this.currentPair;
    }

    private void loadCachePairs() {
        Preconditions.checkState(this.cacheIndex <= this.cachePairs.size());
        if (this.cacheIndex < this.cachePairs.size() || this.expired) {
            return;
        }
        try (RocksIterator iterator = this.dbStorageInstance.iterator();){
            byte[] startRocksKey = this.currentPair == null ? this.getStartDBKey() : this.currentPair.getKey();
            this.cachePairs.clear();
            this.cacheIndex = 0;
            if (startRocksKey == null) {
                iterator.seekToFirst();
            } else {
                iterator.seek(startRocksKey);
            }
            if (this.currentPair != null && !this.currentPair.isDeleted()) {
                iterator.next();
            }
            while (true) {
                if (!iterator.isValid() || this.isEndDBKey(iterator.key())) {
                    this.expired = true;
                    break;
                }
                if (this.cachePairs.size() >= 128) {
                    break;
                }
                RocksDBPair entry = new RocksDBPair(this.dbStorageInstance, iterator.key(), iterator.value());
                this.cachePairs.add(entry);
                iterator.next();
            }
        }
    }
}

