/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.util.Map;
import org.apache.flink.contrib.streaming.state.RocksDBWriteBatchWrapper;
import org.apache.flink.runtime.state.StateAccessException;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;
import org.rocksdb.Checkpoint;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.WriteOptions;

public class RocksDBInstance
implements AutoCloseable {
    private RocksDB db;
    private final WriteOptions writeOptions;
    private final ColumnFamilyHandle columnFamilyHandle;

    RocksDBInstance(RocksDB db, ColumnFamilyHandle handle) {
        Preconditions.checkNotNull(db);
        Preconditions.checkNotNull(handle);
        this.writeOptions = new WriteOptions().setDisableWAL(true);
        this.db = db;
        this.columnFamilyHandle = handle;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((AutoCloseable)this.columnFamilyHandle);
        IOUtils.closeQuietly((AutoCloseable)this.writeOptions);
    }

    byte[] get(byte[] keyBytes) {
        try {
            return this.db.get(this.columnFamilyHandle, keyBytes);
        }
        catch (RocksDBException e2) {
            throw new StateAccessException((Throwable)e2);
        }
    }

    void put(byte[] keyBytes, byte[] valueBytes) {
        try {
            this.db.put(this.columnFamilyHandle, this.writeOptions, keyBytes, valueBytes);
        }
        catch (RocksDBException e2) {
            throw new StateAccessException((Throwable)e2);
        }
    }

    void multiPut(Map<byte[], byte[]> keyValueBytesMap) {
        try (RocksDBWriteBatchWrapper writeBatchWrapper = new RocksDBWriteBatchWrapper(this.db, this.writeOptions);){
            for (Map.Entry<byte[], byte[]> entry : keyValueBytesMap.entrySet()) {
                writeBatchWrapper.put(this.columnFamilyHandle, entry.getKey(), entry.getValue());
            }
        }
        catch (RocksDBException e2) {
            throw new StateAccessException((Throwable)e2);
        }
    }

    void delete(byte[] keyBytes) {
        try {
            this.db.delete(this.writeOptions, keyBytes);
        }
        catch (RocksDBException e2) {
            throw new StateAccessException((Throwable)e2);
        }
    }

    void merge(byte[] keyBytes, byte[] partialValueBytes) {
        try {
            this.db.merge(this.writeOptions, keyBytes, partialValueBytes);
        }
        catch (RocksDBException e2) {
            throw new StateAccessException((Throwable)e2);
        }
    }

    RocksIterator iterator() {
        return this.db.newIterator();
    }

    void snapshot(String localCheckpointPath) throws RocksDBException {
        Checkpoint checkpoint = Checkpoint.create((RocksDB)this.db);
        checkpoint.createCheckpoint(localCheckpointPath);
    }

    RocksDB getDb() {
        return this.db;
    }

    WriteOptions getWriteOptions() {
        return this.writeOptions;
    }

    public ColumnFamilyHandle getColumnFamilyHandle() {
        return this.columnFamilyHandle;
    }

    public static boolean isPrefixWith(byte[] bytes, byte[] prefixBytes) {
        Preconditions.checkArgument(bytes != null);
        Preconditions.checkArgument(prefixBytes != null);
        if (bytes.length < prefixBytes.length) {
            return false;
        }
        for (int i = 0; i < prefixBytes.length; ++i) {
            if (bytes[i] == prefixBytes[i]) continue;
            return false;
        }
        return true;
    }

    static int compare(byte[] leftBytes, byte[] rightBytes) {
        Preconditions.checkArgument(leftBytes != null);
        Preconditions.checkArgument(rightBytes != null);
        int commonLength = Math.min(leftBytes.length, rightBytes.length);
        for (int i = 0; i < commonLength; ++i) {
            int leftByte = leftBytes[i] & 0xFF;
            int rightByte = rightBytes[i] & 0xFF;
            if (leftByte > rightByte) {
                return 1;
            }
            if (leftByte >= rightByte) continue;
            return -1;
        }
        return leftBytes.length - rightBytes.length;
    }
}

