/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.memory.ByteArrayInputStreamWithPos;
import org.apache.flink.core.memory.ByteArrayOutputStreamWithPos;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class RocksDBKeySerializationUtils {
    public static int readKeyGroup(int keyGroupPrefixBytes, DataInputView inputView) throws IOException {
        int keyGroup = 0;
        for (int i = 0; i < keyGroupPrefixBytes; ++i) {
            keyGroup <<= 8;
            keyGroup |= inputView.readByte() & 0xFF;
        }
        return keyGroup;
    }

    public static <K> K readKey(TypeSerializer<K> keySerializer, ByteArrayInputStreamWithPos inputStream, DataInputView inputView, boolean ambiguousKeyPossible) throws IOException {
        int beforeRead = inputStream.getPosition();
        K key = keySerializer.deserialize(inputView);
        if (ambiguousKeyPossible) {
            int length = inputStream.getPosition() - beforeRead;
            RocksDBKeySerializationUtils.readVariableIntBytes(inputView, length);
        }
        return key;
    }

    public static <N> N readNamespace(TypeSerializer<N> namespaceSerializer, ByteArrayInputStreamWithPos inputStream, DataInputView inputView, boolean ambiguousKeyPossible) throws IOException {
        int beforeRead = inputStream.getPosition();
        N namespace = namespaceSerializer.deserialize(inputView);
        if (ambiguousKeyPossible) {
            int length = inputStream.getPosition() - beforeRead;
            RocksDBKeySerializationUtils.readVariableIntBytes(inputView, length);
        }
        return namespace;
    }

    public static <N> void writeNameSpace(N namespace, TypeSerializer<N> namespaceSerializer, ByteArrayOutputStreamWithPos keySerializationStream, DataOutputView keySerializationDataOutputView, boolean ambiguousKeyPossible) throws IOException {
        int beforeWrite = keySerializationStream.getPosition();
        namespaceSerializer.serialize(namespace, keySerializationDataOutputView);
        if (ambiguousKeyPossible) {
            RocksDBKeySerializationUtils.writeLengthFrom(beforeWrite, keySerializationStream, keySerializationDataOutputView);
        }
    }

    public static boolean isAmbiguousKeyPossible(TypeSerializer keySerializer, TypeSerializer namespaceSerializer) {
        return keySerializer.getLength() < 0 && namespaceSerializer.getLength() < 0;
    }

    public static void writeKeyGroup(int keyGroup, int keyGroupPrefixBytes, DataOutputView keySerializationDateDataOutputView) throws IOException {
        int i = keyGroupPrefixBytes;
        while (--i >= 0) {
            keySerializationDateDataOutputView.writeByte(keyGroup >>> (i << 3));
        }
    }

    public static <K> void writeKey(K key, TypeSerializer<K> keySerializer, ByteArrayOutputStreamWithPos keySerializationStream, DataOutputView keySerializationDataOutputView, boolean ambiguousKeyPossible) throws IOException {
        int beforeWrite = keySerializationStream.getPosition();
        keySerializer.serialize(key, keySerializationDataOutputView);
        if (ambiguousKeyPossible) {
            RocksDBKeySerializationUtils.writeLengthFrom(beforeWrite, keySerializationStream, keySerializationDataOutputView);
        }
    }

    private static void readVariableIntBytes(DataInputView inputView, int value) throws IOException {
        do {
            inputView.readByte();
        } while ((value >>>= 8) != 0);
    }

    private static void writeLengthFrom(int fromPosition, ByteArrayOutputStreamWithPos keySerializationStream, DataOutputView keySerializationDateDataOutputView) throws IOException {
        int length = keySerializationStream.getPosition() - fromPosition;
        RocksDBKeySerializationUtils.writeVariableIntBytes(length, keySerializationDateDataOutputView);
    }

    private static void writeVariableIntBytes(int value, DataOutputView keySerializationDateDataOutputView) throws IOException {
        do {
            keySerializationDateDataOutputView.writeByte(value);
        } while ((value >>>= 8) != 0);
    }
}

