/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.contrib.streaming.state;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collection;
import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.ReducingState;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.contrib.streaming.state.AbstractRocksDBState;
import org.apache.flink.contrib.streaming.state.RocksDBKeyedStateBackend;
import org.apache.flink.core.memory.ByteArrayInputStreamWithPos;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.runtime.state.internal.InternalReducingState;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;

public class RocksDBReducingState<K, N, V>
extends AbstractRocksDBState<K, N, V, ReducingState<V>>
implements InternalReducingState<K, N, V> {
    private final ReduceFunction<V> reduceFunction;

    public RocksDBReducingState(ColumnFamilyHandle columnFamily, TypeSerializer<N> namespaceSerializer, TypeSerializer<V> valueSerializer, V defaultValue, ReduceFunction<V> reduceFunction, RocksDBKeyedStateBackend<K> backend) {
        super(columnFamily, namespaceSerializer, valueSerializer, defaultValue, backend);
        this.reduceFunction = reduceFunction;
    }

    public TypeSerializer<K> getKeySerializer() {
        return this.backend.getKeySerializer();
    }

    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    public TypeSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public V get() {
        try {
            this.writeCurrentKeyWithGroupAndNamespace();
            byte[] key = this.keySerializationStream.toByteArray();
            byte[] valueBytes = this.backend.db.get(this.columnFamily, key);
            if (valueBytes == null) {
                return null;
            }
            return (V)this.valueSerializer.deserialize(new DataInputViewStreamWrapper(new ByteArrayInputStream(valueBytes)));
        }
        catch (IOException | RocksDBException e2) {
            throw new RuntimeException("Error while retrieving data from RocksDB", e2);
        }
    }

    public void add(V value) throws IOException {
        try {
            this.writeCurrentKeyWithGroupAndNamespace();
            byte[] key = this.keySerializationStream.toByteArray();
            byte[] valueBytes = this.backend.db.get(this.columnFamily, key);
            DataOutputViewStreamWrapper out = new DataOutputViewStreamWrapper(this.keySerializationStream);
            if (valueBytes == null) {
                this.keySerializationStream.reset();
                this.valueSerializer.serialize(value, out);
                this.backend.db.put(this.columnFamily, this.writeOptions, key, this.keySerializationStream.toByteArray());
            } else {
                Object oldValue = this.valueSerializer.deserialize(new DataInputViewStreamWrapper(new ByteArrayInputStream(valueBytes)));
                V newValue = this.reduceFunction.reduce(oldValue, value);
                this.keySerializationStream.reset();
                this.valueSerializer.serialize(newValue, out);
                this.backend.db.put(this.columnFamily, this.writeOptions, key, this.keySerializationStream.toByteArray());
            }
        }
        catch (Exception e2) {
            throw new RuntimeException("Error while adding data to RocksDB", e2);
        }
    }

    public void mergeNamespaces(N target, Collection<N> sources) throws Exception {
        if (sources == null || sources.isEmpty()) {
            return;
        }
        Object key = this.backend.getCurrentKey();
        int keyGroup = this.backend.getCurrentKeyGroupIndex();
        try {
            Object current = null;
            for (N source : sources) {
                if (source == null) continue;
                this.writeKeyWithGroupAndNamespace(keyGroup, key, source, this.keySerializationStream, this.keySerializationDataOutputView);
                byte[] sourceKey = this.keySerializationStream.toByteArray();
                byte[] valueBytes = this.backend.db.get(this.columnFamily, sourceKey);
                this.backend.db.delete(this.columnFamily, sourceKey);
                if (valueBytes == null) continue;
                Object value = this.valueSerializer.deserialize(new DataInputViewStreamWrapper(new ByteArrayInputStreamWithPos(valueBytes)));
                if (current != null) {
                    current = this.reduceFunction.reduce(current, value);
                    continue;
                }
                current = value;
            }
            if (current != null) {
                this.writeKeyWithGroupAndNamespace(keyGroup, key, target, this.keySerializationStream, this.keySerializationDataOutputView);
                byte[] targetKey = this.keySerializationStream.toByteArray();
                byte[] targetValueBytes = this.backend.db.get(this.columnFamily, targetKey);
                if (targetValueBytes != null) {
                    Object value = this.valueSerializer.deserialize(new DataInputViewStreamWrapper(new ByteArrayInputStreamWithPos(targetValueBytes)));
                    current = this.reduceFunction.reduce(current, value);
                }
                this.keySerializationStream.reset();
                this.valueSerializer.serialize(current, this.keySerializationDataOutputView);
                this.backend.db.put(this.columnFamily, this.writeOptions, targetKey, this.keySerializationStream.toByteArray());
            }
        }
        catch (Exception e2) {
            throw new Exception("Error while merging state in RocksDB", e2);
        }
    }
}

