/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.FSDataInputStream;

@Internal
public class LocalDataInputStream
extends FSDataInputStream {
    private final FileInputStream fis;
    private final FileChannel fileChannel;

    public LocalDataInputStream(File file) throws IOException {
        this.fis = new FileInputStream(file);
        this.fileChannel = this.fis.getChannel();
    }

    @Override
    public void seek(long desired) throws IOException {
        if (desired != this.getPos()) {
            this.fileChannel.position(desired);
        }
    }

    @Override
    public long getPos() throws IOException {
        return this.fileChannel.position();
    }

    @Override
    public int read() throws IOException {
        return this.fis.read();
    }

    @Override
    public int read(@Nonnull byte[] buffer, int offset, int length) throws IOException {
        return this.fis.read(buffer, offset, length);
    }

    @Override
    public void close() throws IOException {
        this.fis.close();
    }

    @Override
    public int available() throws IOException {
        return this.fis.available();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.fis.skip(n);
    }

    public int read(int position, @Nonnull byte[] buffer, int offset, int length) throws IOException {
        ByteBuffer bb = ByteBuffer.wrap(buffer, offset, length);
        return this.fileChannel.read(bb, position);
    }
}

