/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.nio.ByteBuffer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.memory.HybridMemorySegment;
import org.apache.flink.core.memory.MemorySegment;

@Internal
public final class MemorySegmentFactory {
    public static MemorySegment wrap(byte[] buffer) {
        return new HybridMemorySegment(buffer);
    }

    public static MemorySegment allocateUnpooledSegment(int size) {
        return MemorySegmentFactory.allocateUnpooledSegment(size, null);
    }

    public static MemorySegment allocateUnpooledSegment(int size, Object owner) {
        return new HybridMemorySegment(new byte[size], owner);
    }

    public static MemorySegment wrapPooledHeapMemory(byte[] memory, Object owner) {
        return new HybridMemorySegment(memory, owner);
    }

    public static MemorySegment wrapPooledOffHeapMemory(ByteBuffer memory, Object owner) {
        return new HybridMemorySegment(memory, owner);
    }
}

