/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.python.api.streaming.data;

import java.util.Iterator;
import org.apache.flink.util.Preconditions;

class SingleElementPushBackIterator<IN> {
    private IN pushBack = null;
    private final Iterator<IN> iterator;

    SingleElementPushBackIterator(Iterator<IN> iterator) {
        this.iterator = iterator;
    }

    public boolean hasNext() {
        return this.pushBack != null || this.iterator.hasNext();
    }

    public IN next() {
        if (this.pushBack != null) {
            IN obj = this.pushBack;
            this.pushBack = null;
            return obj;
        }
        return this.iterator.next();
    }

    public void pushBack(IN element) {
        Preconditions.checkState(this.pushBack == null, "Already contains an element that was pushed back. This indicates a programming error.");
        this.pushBack = element;
    }
}

