/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.api.Column;
import org.apache.flink.table.api.ComputedColumn;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.Watermark;
import org.apache.flink.table.types.InternalType;
import org.apache.flink.table.types.TimestampType;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class TableSchema
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Column[] columns;
    private final String[] primaryKeys;
    private final String[][] uniqueKeys;
    private final String[][] indexes;
    private final ComputedColumn[] computedColumns;
    private final Watermark[] watermarks;
    private final Map<String, Integer> columnNameToColumnIndex;

    public TableSchema(Column[] columns) {
        this(columns, new String[0], new String[0][], new String[0][], new ComputedColumn[0], new Watermark[0]);
    }

    public TableSchema(Column[] columns, String[] primaryKeys, String[][] uniqueKeys, String[][] indexes, ComputedColumn[] computedColumns, Watermark[] watermarks) {
        int i;
        this.columns = columns;
        this.primaryKeys = primaryKeys;
        this.uniqueKeys = uniqueKeys;
        this.indexes = indexes;
        this.computedColumns = computedColumns;
        this.watermarks = watermarks;
        this.columnNameToColumnIndex = new HashMap<String, Integer>();
        HashSet<String> duplicateNames = new HashSet<String>();
        HashSet<String> uniqueNames = new HashSet<String>();
        for (i = 0; i < this.columns.length; ++i) {
            Preconditions.checkNotNull(columns[i]);
            String fieldName = this.columns[i].name();
            this.columnNameToColumnIndex.put(fieldName, i);
            if (uniqueNames.contains(fieldName)) {
                duplicateNames.add(fieldName);
                continue;
            }
            uniqueNames.add(fieldName);
        }
        if (!duplicateNames.isEmpty()) {
            throw new TableException("Table column names must be unique.\nThe duplicate columns are: " + ((Object)duplicateNames).toString() + "\nAll column names: " + Arrays.toString(Arrays.stream(this.columns).map(Column::name).toArray(String[]::new)));
        }
        for (i = 0; i < primaryKeys.length; ++i) {
            if (this.columnNameToColumnIndex.containsKey(primaryKeys[i])) continue;
            throw new TableException("Primary key field: " + primaryKeys[i] + " not found in table schema.");
        }
        for (i = 0; i < uniqueKeys.length; ++i) {
            String[] uniqueKey = uniqueKeys[i];
            if (null == uniqueKey || 0 == uniqueKey.length) {
                throw new TableException("Unique key should not be empty.");
            }
            for (int j2 = 0; j2 < uniqueKey.length; ++j2) {
                if (this.columnNameToColumnIndex.containsKey(uniqueKey[j2])) continue;
                throw new TableException("Unique key field: " + uniqueKey[j2] + " not found in table schema.");
            }
        }
    }

    public TableSchema(String[] names, InternalType[] types, boolean[] nulls) {
        this(TableSchema.validate(names, types, nulls));
    }

    public TableSchema(String[] names, InternalType[] types) {
        this(TableSchema.validate(names, types));
    }

    private static Column[] validate(String[] names, InternalType[] types, boolean[] nulls) {
        if (names.length != types.length) {
            throw new TableException("Number of column indexes and column names must be equal.\nColumn names count is [" + names.length + "]\nColumn types count is [" + types.length + "]\nColumn names: " + Arrays.toString(names) + "\nColumn types: " + Arrays.toString(types));
        }
        if (names.length != nulls.length) {
            throw new TableException("Number of column names and nullabilities must be equal.\nColumn names count is: " + names.length + "\nColumn nullabilities count is: " + nulls.length + "\nList of all field names: " + Arrays.toString(names) + "\nList of all field nullabilities: " + Arrays.toString(nulls));
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        for (int i = 0; i < names.length; ++i) {
            columns.add(new Column(names[i], types[i], nulls[i]));
        }
        return columns.toArray(new Column[columns.size()]);
    }

    private static Column[] validate(String[] names, InternalType[] types) {
        boolean[] nulls = new boolean[types.length];
        for (int i = 0; i < types.length; ++i) {
            nulls[i] = !TimestampType.ROWTIME_INDICATOR.equals(types[i]) && !TimestampType.PROCTIME_INDICATOR.equals(types[i]);
        }
        return TableSchema.validate(names, types, nulls);
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public String[] getPrimaryKeys() {
        return this.primaryKeys;
    }

    public String[][] getUniqueKeys() {
        return this.uniqueKeys;
    }

    public String[][] getNormalIndexes() {
        ArrayList<String[]> normalIndexes = new ArrayList<String[]>();
        for (String[] fields2 : this.indexes) {
            if (this.isUniqueColumns(fields2)) continue;
            normalIndexes.add(fields2);
        }
        return (String[][])normalIndexes.toArray((T[])new String[0][]);
    }

    public String[][] getUniqueIndexes() {
        ArrayList<String[]> uniqueIndexes = new ArrayList<String[]>();
        for (String[] fields2 : this.indexes) {
            if (!this.isUniqueColumns(fields2)) continue;
            uniqueIndexes.add(fields2);
        }
        return (String[][])uniqueIndexes.toArray((T[])new String[0][]);
    }

    public int getColumnIndex(String columnName) {
        if (this.columnNameToColumnIndex.containsKey(columnName)) {
            return this.columnNameToColumnIndex.get(columnName);
        }
        throw new IllegalArgumentException("The given column name is not in the table schema.");
    }

    public boolean isUniqueColumns(String[] fields2) {
        for (Object[] objectArray : this.uniqueKeys) {
            if (!Arrays.equals(objectArray, fields2)) continue;
            return true;
        }
        return Arrays.equals(this.primaryKeys, fields2);
    }

    public InternalType[] getFieldTypes() {
        return (InternalType[])Arrays.stream(this.columns).map(Column::internalType).toArray(InternalType[]::new);
    }

    public Optional<InternalType> getFieldType(int fieldIndex) {
        if (fieldIndex < 0 || fieldIndex >= this.columns.length) {
            return Optional.empty();
        }
        return Optional.of(this.columns[fieldIndex].internalType());
    }

    public Optional<InternalType> getFieldType(String fieldName) {
        if (this.columnNameToColumnIndex.containsKey(fieldName)) {
            return Optional.of(this.columns[this.columnNameToColumnIndex.get(fieldName)].internalType());
        }
        return Optional.empty();
    }

    public int getFieldCount() {
        return this.columns.length;
    }

    public String[] getFieldNames() {
        return (String[])Arrays.stream(this.columns).map(Column::name).toArray(String[]::new);
    }

    public Optional<String> getFieldName(int fieldIndex) {
        if (fieldIndex < 0 || fieldIndex >= this.columns.length) {
            return Optional.empty();
        }
        return Optional.of(this.columns[fieldIndex].name());
    }

    public boolean[] getFieldNullables() {
        boolean[] nulls = new boolean[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            nulls[i] = this.columns[i].isNullable();
        }
        return nulls;
    }

    @Deprecated
    public InternalType[] getTypes() {
        return (InternalType[])Arrays.stream(this.columns).map(Column::internalType).toArray(InternalType[]::new);
    }

    @Deprecated
    public String[] getColumnNames() {
        return (String[])Arrays.stream(this.columns).map(Column::name).toArray(String[]::new);
    }

    @Deprecated
    public boolean[] getNullables() {
        return this.getFieldNullables();
    }

    public ComputedColumn[] getComputedColumns() {
        return this.computedColumns;
    }

    public Watermark[] getWatermarks() {
        return this.watermarks;
    }

    public Column getColumn(int fieldIndex) {
        Preconditions.checkArgument(fieldIndex >= 0 && fieldIndex < this.columns.length);
        return this.columns[fieldIndex];
    }

    public Map<String, Integer> columnNameToIndex() {
        return this.columnNameToColumnIndex;
    }

    @Deprecated
    public InternalType getType(int fieldIndex) {
        Preconditions.checkArgument(fieldIndex >= 0 && fieldIndex < this.columns.length);
        return this.columns[fieldIndex].internalType();
    }

    @Deprecated
    public Optional<InternalType> getType(String fieldName) {
        if (this.columnNameToColumnIndex.containsKey(fieldName)) {
            return Optional.of(this.columns[this.columnNameToColumnIndex.get(fieldName)].internalType());
        }
        return Optional.empty();
    }

    @Deprecated
    public String getColumnName(int fieldIndex) {
        Preconditions.checkArgument(fieldIndex >= 0 && fieldIndex < this.columns.length);
        return this.columns[fieldIndex].name();
    }

    public String toString() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("root\n");
        for (i = 0; i < this.columns.length; ++i) {
            sb.append(" |-- name: ").append(this.columns[i].name()).append("\n");
            sb.append(" |-- type: ").append(this.columns[i].internalType()).append("\n");
            sb.append(" |-- isNullable: ").append(this.columns[i].isNullable()).append("\n");
        }
        if (this.primaryKeys.length > 0) {
            sb.append("primary keys\n");
            sb.append(" |-- ").append(String.join((CharSequence)", ", this.primaryKeys)).append("\n");
        }
        if (this.uniqueKeys.length > 0) {
            sb.append("unique keys\n");
            for (i = 0; i < this.uniqueKeys.length; ++i) {
                sb.append(" |-- ").append(String.join((CharSequence)", ", this.uniqueKeys[i])).append("\n");
            }
        }
        if (this.indexes.length > 0) {
            sb.append("indexes\n");
            for (i = 0; i < this.indexes.length; ++i) {
                sb.append(" |-- ").append(String.join((CharSequence)", ", this.indexes[i])).append("\n");
            }
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableSchema schema2 = (TableSchema)o;
        return Arrays.equals(this.columns, schema2.columns) && Arrays.equals(this.primaryKeys, schema2.primaryKeys) && TableSchema.twoDimensionArrayEquals(this.uniqueKeys, schema2.uniqueKeys) && TableSchema.twoDimensionArrayEquals(this.indexes, schema2.indexes) && Arrays.equals(this.computedColumns, schema2.computedColumns) && Arrays.equals(this.watermarks, schema2.watermarks);
    }

    private static boolean twoDimensionArrayEquals(String[][] left, String[][] right) {
        if (left == null || right == null) {
            return left == null && right == null;
        }
        if (left.length != right.length) {
            return false;
        }
        for (Object[] objectArray : left) {
            boolean eq = false;
            for (Object[] objectArray2 : right) {
                if (!Arrays.equals(objectArray, objectArray2)) continue;
                eq = true;
                break;
            }
            if (eq) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.columns);
        result = 31 * result + Arrays.hashCode(this.primaryKeys);
        result = 31 * result + Arrays.hashCode((Object[])this.uniqueKeys);
        result = 31 * result + Arrays.hashCode((Object[])this.indexes);
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final List<Column> columns = new ArrayList<Column>();
        private final List<String> primaryKey = new ArrayList<String>();
        private final List<List<String>> uniqueKeys = new ArrayList<List<String>>();
        private final List<List<String>> indexes = new ArrayList<List<String>>();
        private final List<ComputedColumn> computedColumns = new ArrayList<ComputedColumn>();
        private final List<Watermark> watermarks = new ArrayList<Watermark>();

        @Deprecated
        public Builder field(String name, InternalType type) {
            this.columns.add(new Column(name, type));
            return this;
        }

        @Deprecated
        public Builder field(String name, InternalType type, boolean nullable) {
            this.columns.add(new Column(name, type, nullable));
            return this;
        }

        public Builder column(String name, InternalType type) {
            this.columns.add(new Column(name, type));
            return this;
        }

        public Builder column(String name, InternalType type, boolean nullable) {
            this.columns.add(new Column(name, type, nullable));
            return this;
        }

        public Builder primaryKey(String ... fields2) {
            Preconditions.checkArgument(this.primaryKey.isEmpty(), "A primary key " + this.primaryKey + " have been defined, can not define another primary key " + Arrays.toString(fields2));
            this.primaryKey.addAll(Arrays.asList(fields2));
            this.indexes.add(Arrays.asList(fields2));
            return this;
        }

        public Builder uniqueKey(String ... fields2) {
            this.uniqueKeys.add(Arrays.asList(fields2));
            this.indexes.add(Arrays.asList(fields2));
            return this;
        }

        public Builder normalIndex(String ... fields2) {
            this.indexes.add(Arrays.asList(fields2));
            return this;
        }

        public Builder uniqueIndex(String ... fields2) {
            return this.uniqueKey(fields2);
        }

        public Builder computedColumn(String name, String expression2) {
            this.computedColumns.add(new ComputedColumn(name, expression2));
            return this;
        }

        public Builder watermark(String name, String eventTime, long offset) {
            this.watermarks.add(new Watermark(name, eventTime, offset));
            return this;
        }

        public TableSchema build() {
            return new TableSchema(this.columns.toArray(new Column[0]), this.primaryKey.toArray(new String[0]), (String[][])this.uniqueKeys.stream().map(u -> u.toArray(new String[0])).collect(Collectors.toList()).toArray((T[])new String[this.uniqueKeys.size()][]), (String[][])this.indexes.stream().map(u -> u.toArray(new String[0])).collect(Collectors.toList()).toArray((T[])new String[this.indexes.size()][]), this.computedColumns.toArray(new ComputedColumn[0]), this.watermarks.toArray(new Watermark[0]));
        }
    }
}

