/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.window;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.api.window.Window;

public class TimeWindow
extends Window {
    private final long start;
    private final long end;

    public TimeWindow(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    @Override
    public long maxTimestamp() {
        return this.end - 1L;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeWindow window = (TimeWindow)o;
        return this.end == window.end && this.start == window.start;
    }

    @Override
    public int hashCode() {
        return (int)(this.start + (long)this.modInverse((int)(this.end << 1) + 1));
    }

    private int modInverse(int x) {
        int inverse = x * x * x;
        inverse *= 2 - x * inverse;
        inverse *= 2 - x * inverse;
        inverse *= 2 - x * inverse;
        return inverse;
    }

    public String toString() {
        return "TimeWindow{start=" + this.start + ", end=" + this.end + '}';
    }

    public boolean intersects(TimeWindow other) {
        return this.start <= other.end && this.end >= other.start;
    }

    public TimeWindow cover(TimeWindow other) {
        return new TimeWindow(Math.min(this.start, other.start), Math.max(this.end, other.end));
    }

    @Override
    public int compareTo(Window o) {
        TimeWindow that = (TimeWindow)o;
        if (this.start == that.start) {
            return Long.compare(this.end, that.end);
        }
        return Long.compare(this.start, that.start);
    }

    public static long getWindowStartWithOffset(long timestamp, long offset, long windowSize) {
        return timestamp - (timestamp - offset + windowSize) % windowSize;
    }

    public static TimeWindow of(long start, long end) {
        return new TimeWindow(start, end);
    }

    public static class Serializer
    extends TypeSerializerSingleton<TimeWindow> {
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isImmutableType() {
            return true;
        }

        @Override
        public TimeWindow createInstance() {
            return null;
        }

        @Override
        public TimeWindow copy(TimeWindow from) {
            return from;
        }

        @Override
        public TimeWindow copy(TimeWindow from, TimeWindow reuse) {
            return from;
        }

        @Override
        public int getLength() {
            return 0;
        }

        @Override
        public void serialize(TimeWindow record, DataOutputView target) throws IOException {
            target.writeLong(record.start);
            target.writeLong(record.end);
        }

        @Override
        public TimeWindow deserialize(DataInputView source) throws IOException {
            long start = source.readLong();
            long end = source.readLong();
            return new TimeWindow(start, end);
        }

        @Override
        public TimeWindow deserialize(TimeWindow reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        @Override
        public void copy(DataInputView source, DataOutputView target) throws IOException {
            target.writeLong(source.readLong());
            target.writeLong(source.readLong());
        }

        @Override
        public boolean canEqual(Object obj) {
            return obj instanceof Serializer;
        }
    }
}

